/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.tool.extremwerte;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import luwa.marlin.database.PegeldatenDatenbank;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.JahrbuchModus;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.model.JahrbuchseitenConfiguration;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.repository.sql.SQLDatenRepository;
import luwa.marlin.ship_library.view.ExtremwerteRenderModel;
import luwa.marlin.ship_library.view.JahrbuchseiteRenderModel;

public class Extremwerte {
    private final Messstelle messstelle;
    private final JahrbuchseiteRenderModel model;
    private static final String spaltentrennzeichen = "\t";

    public Extremwerte(Jahrbuchseite data) {
        this.messstelle = data.messstelle();
        this.model = new JahrbuchseiteRenderModel(data);
    }

    public static void main(String[] args) throws Exception {
        DataSource dataSource = PegeldatenDatenbank.fromSystemEnvironment().createAsDataSource();
        try (Connection connection = dataSource.getConnection();){
            SQLDatenRepository dataProvider = new SQLDatenRepository(connection);
            Optional<Parameter> optionalParameter = Extremwerte.parameterFromArguments(args);
            if (optionalParameter.isEmpty()) {
                System.err.println("Bitte NNQ oder NNW als Kommandozeilenparameter angeben");
                return;
            }
            Parameter parameter = optionalParameter.get();
            int vonJahr = 1980;
            int bisJahr = 2019;
            Optional<Integer> jahr = Optional.of(2019);
            List<Long> pegel = List.of(Long.valueOf(3301L));
            try (PrintStream out = new PrintStream(new FileOutputStream(Extremwerte.dateinameF\u00fcr(parameter), false));){
                Extremwerte.schreibePegel(out, dataProvider, 1980, 2019, jahr, pegel);
            }
        }
    }

    private static Optional<Parameter> parameterFromArguments(String[] args) {
        if (args.length < 1) {
            return Optional.empty();
        }
        if ("NNQ".equalsIgnoreCase(args[0])) {
            return Optional.of(Parameter.q);
        }
        if ("NNW".equalsIgnoreCase(args[0])) {
            return Optional.of(Parameter.w);
        }
        return Optional.empty();
    }

    private static String dateinameF\u00fcr(Parameter parameter) {
        String NNx = "NN" + parameter.symbol();
        String zusatz = parameter == Parameter.q ? " historisch" : "";
        String zeitstempel = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(ZonedDateTime.now());
        return NNx + zusatz + " " + zeitstempel + ".csv";
    }

    private static void schreibePegel(PrintStream out, SQLDatenRepository dataProvider, int vonJahr, int bisJahr, Optional<Integer> jahr, List<Long> pegel) {
        boolean mit\u00dcberschriften = true;
        int n2 = 1;
        int total = pegel.size();
        for (Long messstellenNummer : pegel) {
            System.out.println(n2 + " / " + total);
            try {
                JahrbuchseitenConfiguration jahrbuchseitenConfig = new JahrbuchseitenConfiguration(messstellenNummer, Optional.empty(), vonJahr, bisJahr, AbflussOderWasserstand.W, JahrbuchModus.nachRichtlinie, jahr);
                Jahrbuchseite jahrbuchseite = new Jahrbuchseite(jahrbuchseitenConfig, dataProvider);
                Extremwerte extremwerte = new Extremwerte(jahrbuchseite);
                extremwerte.writeTo(out, mit\u00dcberschriften);
            }
            catch (Exception e2) {
                System.err.println("Konnte Pegel " + messstellenNummer + " nicht verarbeiten.");
                e2.printStackTrace(System.err);
            }
            mit\u00dcberschriften = false;
            ++n2;
        }
    }

    public void writeTo(PrintStream out, boolean mit\u00dcberschriften) {
        ExtremwerteRenderModel extremwerte = this.model.extremwerte();
        ExtremwerteRenderModel.HochOderNiedrigwasser niedrigwasser = ExtremwerteRenderModel.HochOderNiedrigwasser.Niedrigwasser;
        List spalten = extremwerte.spalten().stream().filter(spalte -> spalte != ExtremwerteRenderModel.Spalte.Spende).collect(Collectors.toList());
        if (mit\u00dcberschriften) {
            List<String> spalten\u00fcberschriften = Stream.concat(Stream.of("Messtellen-Nr.", "Standort", "Gew\u00e4sser", "Messnetz", "Rang"), spalten.stream().map(extremwerte::header)).collect(Collectors.toList());
            Extremwerte.schreibeZeile(out, spalten\u00fcberschriften);
        }
        int n2 = 1;
        while (n2 <= 10) {
            List<String> messtelle = List.of(String.valueOf(this.messstelle.nummer()), this.messstelle.standort(), this.messstelle.gew\u00e4sser(), this.messstelle.messnetz());
            ArrayList<String> zeile = new ArrayList<String>(messtelle);
            zeile.add(String.valueOf(n2));
            int finalN = n2++;
            zeile.addAll(spalten.stream().map(spalte -> extremwerte.model(niedrigwasser, (ExtremwerteRenderModel.Spalte)((Object)spalte)).get(finalN)).collect(Collectors.toList()));
            out.println(String.join((CharSequence)spaltentrennzeichen, zeile));
        }
    }

    private static void schreibeZeile(PrintStream out, List<String> eintr\u00e4ge) {
        out.println(String.join((CharSequence)spaltentrennzeichen, eintr\u00e4ge));
    }
}

