/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.repository.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Optional;
import luwa.marlin.configuration.stammdaten.StammdatenKonfiguration;
import luwa.marlin.ship_library.model.uebersicht.PegelMitN\u00e4chsterPegelschauModel;
import luwa.marlin.ship_library.model.uebersicht.PegelMitUng\u00fcltigerWQBeziehungModel;
import luwa.marlin.ship_library.model.uebersicht.ProjektHWGKAbgleichModel;
import luwa.marlin.ship_library.repository.\u00dcbersichtsRepository;
import luwa.marlin.sql.SqlHelpers;

public class SQL\u00dcbersichtsRepository
implements \u00dcbersichtsRepository {
    private final Connection connection;
    private static final long statusWAu\u00dferBetrieb = 4L;
    private static final long statusQAu\u00dferBetrieb = 5L;
    private static final long statusWundQAu\u00dferBetrieb = 6L;

    public SQL\u00dcbersichtsRepository(Connection connection) {
        this.connection = connection;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjektHWGKAbgleichModel projektHWGKAbgleich() {
        String pegeldatenView = StammdatenKonfiguration.stammdaten().pegeldatenView();
        String sql = "WITH erste_gueltigkeit AS (   SELECT messtellen_nr, kurve, MIN(von) AS erste_gueltigkeit   FROM ak_gueltigkeit   GROUP BY messtellen_nr, kurve   ORDER BY messtellen_nr, kurve ), aktuelle_kurve_gueltig_von AS (   SELECT messtellen_nr, MAX(von) von   FROM ak_gueltigkeit   GROUP BY messtellen_nr   ORDER BY messtellen_nr ), aktuelle_kurve AS (   SELECT ag.messtellen_nr, ag.kurve, ak.kurve AS kurve_name   FROM aktuelle_kurve_gueltig_von akgv   LEFT OUTER JOIN ak_gueltigkeit ag ON akgv.messtellen_nr=ag.messtellen_nr AND akgv.von=ag.von   LEFT OUTER JOIN ak ON ak.id=ag.kurve ) SELECT     pd.messtellen_nr,     pd.standort,     pd.gewaesser,     sl_eigentuemer.gwd_langname AS eigentuemer,     sl_gwb.gwb_langname AS betreiber,     h.hwgk_sitzung_vom,     h.kurve,     eg.erste_gueltigkeit AS kurve_erste_gueltigkeit,     h.status,     h.status_id,     h.pruef_bemerkung,     akt.kurve_name as akt_kurve,     eg2.erste_gueltigkeit as akt_kurve_erste_gueltigkeit,     hvz.kurve AS hvz_kurve   FROM " + pegeldatenView + " pd   LEFT OUTER JOIN v_hwgk h ON pd.messtellen_nr=h.messtellen_nr   LEFT OUTER JOIN sl_gwb ON sl_gwb.gwb_nr=pd.gwb_nr   LEFT OUTER JOIN sl_eigentuemer ON sl_eigentuemer.gwd_nr=pd.gwd_nr   LEFT OUTER JOIN v_hvz_freigabe hvz ON hvz.messtellen_nr=pd.messtellen_nr   LEFT OUTER JOIN ak ON pd.messtellen_nr=ak.messtellen_nr AND h.kurve=ak.kurve   LEFT OUTER JOIN erste_gueltigkeit eg ON eg.messtellen_nr=pd.messtellen_nr AND eg.kurve=ak.id   LEFT OUTER JOIN aktuelle_kurve akt ON akt.messtellen_nr=pd.messtellen_nr   LEFT OUTER JOIN erste_gueltigkeit eg2 ON eg2.messtellen_nr=pd.messtellen_nr AND eg2.kurve=akt.kurve   WHERE pd.status NOT IN (2, 3) AND pd.messnetz_nr=1   ORDER BY pd.gwd_nr ASC, pd.gwb_nr ASC, messtellen_nr ASC, h.hwgk_sitzung_vom DESC";
        try (PreparedStatement query = this.connection.prepareStatement(sql);){
            ProjektHWGKAbgleichModel projektHWGKAbgleichModel;
            block15: {
                ResultSet rs = query.executeQuery();
                try {
                    ArrayList<ProjektHWGKAbgleichModel.Zeile> zeilen = new ArrayList<ProjektHWGKAbgleichModel.Zeile>();
                    while (rs.next()) {
                        String eigent\u00fcmer = SqlHelpers.getNullSafeString(rs, "eigentuemer");
                        String betreiber = SqlHelpers.getNullSafeString(rs, "betreiber");
                        ArrayList<ProjektHWGKAbgleichModel.Bemerkung> bemerkungen = new ArrayList<ProjektHWGKAbgleichModel.Bemerkung>();
                        Optional<Integer> statusId = SqlHelpers.getOptionalInt(rs, "status_id");
                        Optional statusFarbe = statusId.flatMap(this::farbeF\u00fcrStatus);
                        Optional<String> statusText = SqlHelpers.getOptionalString(rs, "status");
                        statusText.ifPresent(s2 -> bemerkungen.add(new ProjektHWGKAbgleichModel.Bemerkung((String)s2, statusFarbe)));
                        Optional<String> pr\u00fcfBemerkung = SqlHelpers.getOptionalString(rs, "pruef_bemerkung");
                        pr\u00fcfBemerkung.ifPresent(s2 -> bemerkungen.add(new ProjektHWGKAbgleichModel.Bemerkung((String)s2, Optional.empty())));
                        Optional<ZonedDateTime> abflusskurveErsteG\u00fcltigkeit = SqlHelpers.getNullableDateTime(rs, "kurve_erste_gueltigkeit");
                        Optional<ZonedDateTime> aktuelleAbflusskurveErsteG\u00fcltigkeit = SqlHelpers.getNullableDateTime(rs, "akt_kurve_erste_gueltigkeit");
                        zeilen.add(new ProjektHWGKAbgleichModel.Zeile(eigent\u00fcmer, betreiber, new ProjektHWGKAbgleichModel.Messstelle(rs.getLong("messtellen_nr"), SqlHelpers.getNullSafeString(rs, "standort"), SqlHelpers.getNullSafeString(rs, "gewaesser")), SqlHelpers.getNullableDateTime(rs, "hwgk_sitzung_vom"), SqlHelpers.getOptionalString(rs, "kurve").map(name -> new ProjektHWGKAbgleichModel.Abflusskurve((String)name, abflusskurveErsteG\u00fcltigkeit)), bemerkungen, SqlHelpers.getOptionalString(rs, "akt_kurve").map(name -> new ProjektHWGKAbgleichModel.Abflusskurve((String)name, aktuelleAbflusskurveErsteG\u00fcltigkeit)), SqlHelpers.getOptionalString(rs, "hvz_kurve")));
                    }
                    projektHWGKAbgleichModel = ProjektHWGKAbgleichModel.ausZeilen(zeilen);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return projektHWGKAbgleichModel;
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte Daten f\u00fcr \u00dcbersicht HWGK-Abgleich nicht aus der Datenbank laden", e2);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public PegelMitUng\u00fcltigerWQBeziehungModel pegelMitUng\u00fcltigerWQBeziehung() {
        String pegeldatenView = StammdatenKonfiguration.stammdaten().pegeldatenView();
        String sql = "WITH aktuelle_kurve_gueltig_von AS (   SELECT messtellen_nr, MAX(von) von   FROM ak_gueltigkeit   GROUP BY messtellen_nr   ORDER BY messtellen_nr ), aktuelle_kurve AS (   SELECT ag.messtellen_nr, ag.kurve, ak.kurve AS kurve_name, ag.von   FROM aktuelle_kurve_gueltig_von akgv   LEFT OUTER JOIN ak_gueltigkeit ag ON akgv.messtellen_nr=ag.messtellen_nr AND akgv.von=ag.von   LEFT OUTER JOIN ak ON ak.id=ag.kurve ) SELECT   pd.messtellen_nr,   pd.standort,   pd.gewaesser,   sl_eigentuemer.gwd_langname as eigentuemer,   sl_gwb.gwb_langname as betreiber,   pd.status,   akt.kurve_name as akt_kurve,   akt.von as akt_kurve_von FROM " + pegeldatenView + " pd LEFT OUTER JOIN sl_gwb on sl_gwb.gwb_nr=pd.gwb_nr LEFT OUTER JOIN sl_eigentuemer on sl_eigentuemer.gwd_nr=pd.gwd_nr LEFT OUTER JOIN aktuelle_kurve akt ON akt.messtellen_nr=pd.messtellen_nr WHERE pd.status NOT IN (2, 3) AND pd.messnetz_nr=1 AND pd.pegeltyp_nr NOT IN (2, 3, 6) AND akt.kurve_name IS NULL AND akt.von IS NULL ORDER BY pd.gwd_nr ASC, pd.gwb_nr ASC, pd.messtellen_nr ASC";
        try (PreparedStatement query = this.connection.prepareStatement(sql);){
            PegelMitUng\u00fcltigerWQBeziehungModel pegelMitUng\u00fcltigerWQBeziehungModel;
            block15: {
                ResultSet rs = query.executeQuery();
                try {
                    ArrayList<PegelMitUng\u00fcltigerWQBeziehungModel.Zeile> zeilen = new ArrayList<PegelMitUng\u00fcltigerWQBeziehungModel.Zeile>();
                    while (rs.next()) {
                        String eigent\u00fcmer = SqlHelpers.getNullSafeString(rs, "eigentuemer");
                        String betreiber = SqlHelpers.getNullSafeString(rs, "betreiber");
                        Optional<Long> status = SqlHelpers.getOptionalLong(rs, "status");
                        Optional<ZonedDateTime> aktuelleAbflusskurveG\u00fcltigSeit = SqlHelpers.getNullableDateTime(rs, "akt_kurve_von");
                        zeilen.add(new PegelMitUng\u00fcltigerWQBeziehungModel.Zeile(eigent\u00fcmer, betreiber, new PegelMitUng\u00fcltigerWQBeziehungModel.Messstelle(rs.getLong("messtellen_nr"), SqlHelpers.getNullSafeString(rs, "standort"), SqlHelpers.getNullSafeString(rs, "gewaesser")), status.isPresent() && (status.get() == 4L || status.get() == 6L), status.isPresent() && (status.get() == 5L || status.get() == 6L), SqlHelpers.getOptionalString(rs, "akt_kurve").map(name -> new PegelMitUng\u00fcltigerWQBeziehungModel.G\u00fcltigeAbflusskurve((String)name, (ZonedDateTime)aktuelleAbflusskurveG\u00fcltigSeit.get())), aktuelleAbflusskurveG\u00fcltigSeit.isPresent()));
                    }
                    pegelMitUng\u00fcltigerWQBeziehungModel = PegelMitUng\u00fcltigerWQBeziehungModel.ausZeilen(zeilen);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return pegelMitUng\u00fcltigerWQBeziehungModel;
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte Daten f\u00fcr \u00dcbersicht Pegel mit ung\u00fcltiger W-Q-Beziehung nicht aus der Datenbank laden", e2);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public PegelMitN\u00e4chsterPegelschauModel pegelMitN\u00e4chsterPegelschau() {
        String pegeldatenView = StammdatenKonfiguration.stammdaten().pegeldatenView();
        String sql = "WITH letzte_pegelschau AS (   SELECT     messtellen_nr,     MAX(ps.gueltig_von) datum_letzte_pegelschau     FROM v_pegeldaten pd     LEFT OUTER JOIN sd_metadaten md ON md.messstelle_nr=pd.messtellen_nr     LEFT OUTER JOIN sd_ap_qual_pegelschau ps ON ps.metadaten_id=md.id     GROUP BY messtellen_nr     ORDER BY messtellen_nr ) SELECT   pd.messtellen_nr,   pd.standort,   pd.gewaesser,   sl_eigentuemer.gwd_langname as eigentuemer,   sl_gwb.gwb_langname as betreiber,   ps.datum_letzte_pegelschau+(INTERVAL '3' YEAR) AS datum_pegelschau_faellig   FROM " + pegeldatenView + " pd   LEFT OUTER JOIN sl_gwb on sl_gwb.gwb_nr=pd.gwb_nr   LEFT OUTER JOIN sl_eigentuemer on sl_eigentuemer.gwd_nr=pd.gwd_nr   LEFT OUTER JOIN letzte_pegelschau ps ON ps.messtellen_nr=pd.messtellen_nr   WHERE pd.status NOT IN (2, 3) AND pd.messnetz_nr=1   ORDER BY pd.gwd_nr, pd.gwb_nr, ps.datum_letzte_pegelschau, pd.messtellen_nr";
        try (PreparedStatement query = this.connection.prepareStatement(sql);){
            PegelMitN\u00e4chsterPegelschauModel pegelMitN\u00e4chsterPegelschauModel;
            block15: {
                ResultSet rs = query.executeQuery();
                try {
                    ArrayList<PegelMitN\u00e4chsterPegelschauModel.Zeile> zeilen = new ArrayList<PegelMitN\u00e4chsterPegelschauModel.Zeile>();
                    while (rs.next()) {
                        String eigent\u00fcmer = SqlHelpers.getNullSafeString(rs, "eigentuemer");
                        String betreiber = SqlHelpers.getNullSafeString(rs, "betreiber");
                        Optional<ZonedDateTime> datumPegelschauF\u00e4llig = SqlHelpers.getNullableDateTime(rs, "datum_pegelschau_faellig");
                        zeilen.add(new PegelMitN\u00e4chsterPegelschauModel.Zeile(eigent\u00fcmer, betreiber, new PegelMitN\u00e4chsterPegelschauModel.Messstelle(rs.getLong("messtellen_nr"), SqlHelpers.getNullSafeString(rs, "standort"), SqlHelpers.getNullSafeString(rs, "gewaesser")), datumPegelschauF\u00e4llig));
                    }
                    pegelMitN\u00e4chsterPegelschauModel = PegelMitN\u00e4chsterPegelschauModel.ausZeilen(zeilen);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return pegelMitN\u00e4chsterPegelschauModel;
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte Daten f\u00fcr \u00dcbersicht Pegel mit n\u00e4chster Pegelschau nicht aus der Datenbank laden", e2);
        }
    }

    private Optional<ProjektHWGKAbgleichModel.BemerkungFarbe> farbeF\u00fcrStatus(int statusId) {
        return switch (statusId) {
            case 1 -> Optional.of(ProjektHWGKAbgleichModel.BemerkungFarbe.gr\u00fcn);
            case 2 -> Optional.of(ProjektHWGKAbgleichModel.BemerkungFarbe.rot);
            case 3 -> Optional.of(ProjektHWGKAbgleichModel.BemerkungFarbe.grau);
            case 4 -> Optional.of(ProjektHWGKAbgleichModel.BemerkungFarbe.gelb);
            default -> Optional.empty();
        };
    }
}

