/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class YearMonth
implements Comparable<YearMonth> {
    public static final int november = 11;
    private static final String[] kurzeMonatsnamen = new String[]{"Jan", "Feb", "Mrz", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"};
    private final int year;
    private final int month;

    public YearMonth(DateTime date) {
        this(date.getYear(), date.getMonthOfYear());
    }

    public YearMonth(int year, int month) {
        this.year = year;
        this.month = month;
    }

    public int year() {
        return this.year;
    }

    public int month() {
        return this.month;
    }

    public String shortName() {
        return kurzeMonatsnamen[this.month - 1];
    }

    public boolean contains(DateTime time) {
        return this.year == time.getYear() && this.month == time.getMonthOfYear();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        YearMonth yearMonth = (YearMonth)o2;
        if (this.month != yearMonth.month) {
            return false;
        }
        return this.year == yearMonth.year;
    }

    public int hashCode() {
        int result = this.year;
        result = 31 * result + this.month;
        return result;
    }

    public String toString() {
        return String.format("%d/%d", this.month(), this.year());
    }

    public YearMonth successor() {
        return new YearMonth(this.dateTime().plusMonths(1));
    }

    public boolean isAfter(YearMonth other) {
        return this.dateTime().isAfter(other.dateTime());
    }

    public YearMonth next() {
        return new YearMonth(this.dateTime().plusMonths(1));
    }

    public DateTime dateTime() {
        return new DateTime(this.year(), this.month(), 1, 0, 0, 0, DateTimeZone.forOffsetHours(1));
    }

    public DateTime startOfMonth() {
        return this.dateTime();
    }

    public DateTime endOfMonth() {
        return new DateTime(this.year(), this.month(), this.lastDayOfMonth(), 23, 59, 59, 999, DateTimeZone.forOffsetHours(1));
    }

    public int lastDayOfMonth() {
        return this.startOfMonth().dayOfMonth().withMaximumValue().getDayOfMonth();
    }

    public Interval interval() {
        return new Interval((ReadableInstant)this.startOfMonth(), (ReadableInstant)this.endOfMonth());
    }

    public Iterable<Day> days() {
        ArrayList<Day> days = new ArrayList<Day>();
        DateTime time = this.dateTime();
        while (time.isBefore(this.endOfMonth())) {
            days.add(new Day(time));
            time = time.plusDays(1);
        }
        return days;
    }

    public Abflussjahr abflussjahr() {
        if (this.month() >= 11) {
            return new Abflussjahr(this.year() + 1);
        }
        return new Abflussjahr(this.year());
    }

    public Kalenderjahr calendarYear() {
        return new Kalenderjahr(this.year());
    }

    @Override
    public int compareTo(YearMonth o2) {
        if (o2 == null) {
            return 1;
        }
        if (this.isAfter(o2)) {
            return 1;
        }
        if (this.equals(o2)) {
            return 0;
        }
        return -1;
    }

    public boolean istAktuellerMonat() {
        DateTime now = new DateTime(DateTimeZone.forOffsetHours(1));
        return this.year == now.getYear() && this.month == now.getMonthOfYear();
    }

    public static Iterable<YearMonth> monateIn(Interval interval) {
        return Stream.iterate(interval.getStart(), month -> month.isBefore(interval.getEnd()), month -> month.plusMonths(1)).map(YearMonth::new).collect(Collectors.toList());
    }
}

