/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.model.year.YearMonthIterator;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class Year
implements Iterable<YearMonth> {
    protected static final int january = 1;
    protected static final int april = 4;
    protected static final int may = 5;
    protected static final int october = 10;
    protected static final int november = 11;
    protected static final int december = 12;
    private final int year;

    public Year(int year) {
        this.year = year;
    }

    public int year() {
        return this.year;
    }

    public abstract YearMonth anfangsmonat();

    public abstract YearMonth endmonat();

    public boolean contains(DateTime timestamp) {
        return this.interval().contains(timestamp);
    }

    public Interval interval() {
        return new Interval((ReadableInstant)this.anfangsmonat().dateTime(), (ReadableInstant)this.endmonat().dateTime().plusMonths(1));
    }

    public boolean istSchaltjahr() {
        if (this.year % 4 == 0) {
            if (this.year % 400 == 0) {
                return true;
            }
            return this.year % 100 != 0;
        }
        return false;
    }

    @Override
    public Iterator<YearMonth> iterator() {
        return new YearMonthIterator(this.anfangsmonat(), this.endmonat());
    }

    public Supplier<Stream<YearMonth>> monate() {
        return () -> StreamSupport.stream(this.spliterator(), false);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Year that = (Year)o2;
        return this.year == that.year;
    }

    public int hashCode() {
        return this.year;
    }
}

