/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import luwa.marlin.ship_library.model.year.YearMonth;
import org.joda.time.DateTime;

public class HydrologicalHalfYear {
    private final int year;
    private final Season season;

    private static Season findSeason(DateTime timestamp) {
        int year = timestamp.getYear();
        if (timestamp.isBefore(new YearMonth(year, 5).dateTime())) {
            return Season.winter;
        }
        if (timestamp.isBefore(new YearMonth(year, 11).dateTime())) {
            return Season.summer;
        }
        return Season.winter;
    }

    private static int findYear(DateTime timestamp) {
        int year = timestamp.getYear();
        if (timestamp.isBefore(new YearMonth(year, 11).dateTime())) {
            return year;
        }
        return year + 1;
    }

    public HydrologicalHalfYear(DateTime timestamp) {
        this(HydrologicalHalfYear.findYear(timestamp), HydrologicalHalfYear.findSeason(timestamp));
    }

    private HydrologicalHalfYear(int year, Season season) {
        this.year = year;
        this.season = season;
    }

    public Season season() {
        return this.season;
    }

    public int year() {
        return this.year;
    }

    public HydrologicalHalfYear successor() {
        if (this.season() == Season.winter) {
            return new HydrologicalHalfYear(this.year(), Season.summer);
        }
        return new HydrologicalHalfYear(this.year() + 1, Season.winter);
    }

    public boolean isBefore(HydrologicalHalfYear end) {
        if (this.year() == end.year()) {
            return this.season == Season.winter && end.season == Season.summer;
        }
        return this.year() < end.year();
    }

    public DateTime dateTime() {
        if (this.season() == Season.winter) {
            return new YearMonth(this.year() - 1, 11).dateTime();
        }
        return new YearMonth(this.year(), 5).dateTime();
    }

    private static enum Season {
        summer,
        winter;

    }
}

