/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import luwa.marlin.ship_library.model.year.YearMonth;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Day {
    private final int year;
    private final int month;
    private final int day;

    public Day(DateTime date) {
        this(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
    }

    public Day(YearMonth month, int day) {
        this(month.year(), month.month(), day);
    }

    public Day(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public DateTime dateTime() {
        return new DateTime(this.year(), this.month(), this.day(), 0, 0, 0, 0, DateTimeZone.forOffsetHours(1));
    }

    public int year() {
        return this.year;
    }

    public int month() {
        return this.month;
    }

    public YearMonth yearMonth() {
        return new YearMonth(this.year, this.month);
    }

    public int day() {
        return this.day;
    }

    public Day successor() {
        return new Day(this.dateTime().plusDays(1));
    }

    public boolean isBefore(Day day) {
        return this.dateTime().isBefore(day.dateTime());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Day day1 = (Day)o2;
        if (this.year != day1.year) {
            return false;
        }
        if (this.month != day1.month) {
            return false;
        }
        return this.day == day1.day;
    }

    public int hashCode() {
        int result = this.year;
        result = 31 * result + this.month;
        result = 31 * result + this.day;
        return result;
    }

    public String toString() {
        return IntStream.of(this.year, this.month, this.day).mapToObj(String::valueOf).collect(Collectors.joining("-"));
    }
}

