/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import java.util.Iterator;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.model.year.YearsRange;

public class CalendarYearsRange
extends YearsRange<Kalenderjahr> {
    public CalendarYearsRange(int startYear, int endYear) {
        this(new Kalenderjahr(startYear), new Kalenderjahr(endYear));
    }

    public CalendarYearsRange(Kalenderjahr startYear, Kalenderjahr endYear) {
        super(startYear, endYear);
    }

    @Override
    public Iterator<Kalenderjahr> iterator() {
        return new CalendarYearIterator(this);
    }

    @Override
    public Iterable<YearMonth> months(int month) {
        CalendarYearsRange yearsRange = this;
        return () -> new MonthsIterator(yearsRange, month);
    }

    private static class CalendarYearIterator
    implements Iterator<Kalenderjahr> {
        private final YearsRange<Kalenderjahr> years;
        private int currentYear;

        public CalendarYearIterator(YearsRange<Kalenderjahr> years) {
            this.years = years;
            this.currentYear = years.startYear().year();
        }

        @Override
        public boolean hasNext() {
            return this.currentYear <= this.years.endYear().year();
        }

        @Override
        public Kalenderjahr next() {
            Kalenderjahr next = new Kalenderjahr(this.currentYear);
            ++this.currentYear;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MonthsIterator
    implements Iterator<YearMonth> {
        private final int endYear;
        private final int month;
        private int currentYear;

        public MonthsIterator(YearsRange<Kalenderjahr> years, int month) {
            int startYear = years.startYear().year();
            this.endYear = years.endYear().year();
            this.month = month;
            this.currentYear = startYear;
        }

        @Override
        public boolean hasNext() {
            return this.currentYear <= this.endYear;
        }

        @Override
        public YearMonth next() {
            YearMonth next = new YearMonth(this.currentYear, this.month);
            ++this.currentYear;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

