/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.value;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.TimeZone;
import luwa.marlin.ship_library.model.value.Value;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.util.UnzureichendeDatenlage;
import luwa.marlin.time.Interval;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimestampedValue
implements Value,
Comparable<TimestampedValue> {
    public final DateTime timestamp;
    public final double value;

    public TimestampedValue(DateTime timestamp, Double value) {
        if (null == value) {
            value = Double.NaN;
        }
        this.timestamp = timestamp;
        this.value = value;
    }

    public TimestampedValue(ZonedDateTime timestamp, Double value) {
        this(TimestampedValue.zonedDateTimeToJodaDateTime(timestamp), value);
    }

    public static DateTime zonedDateTimeToJodaDateTime(ZonedDateTime timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new DateTime(timestamp.toInstant().toEpochMilli(), DateTimeZone.forTimeZone(TimeZone.getTimeZone(timestamp.getZone())));
    }

    public static ZonedDateTime jodaDateTimeToZonedDateTime(DateTime time) {
        if (time == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(time.getMillis()), ZoneId.of(time.getZone().getID(), ZoneId.SHORT_IDS));
    }

    public static Interval toZonedInterval(org.joda.time.Interval interval) {
        return new Interval(TimestampedValue.jodaDateTimeToZonedDateTime(interval.getStart()), TimestampedValue.jodaDateTimeToZonedDateTime(interval.getEnd()));
    }

    public TimestampedValue(ZonedDateTime timestamp, Optional<Double> value) {
        this(TimestampedValue.zonedDateTimeToJodaDateTime(timestamp), value);
    }

    public TimestampedValue(DateTime timestamp, Optional<Double> value) {
        this(timestamp, value.orElse(Double.NaN));
    }

    public TimestampedValue(DateTime timestamp, double value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public TimestampedValue(DateTime timestamp) {
        this(timestamp, Double.NaN);
    }

    public DateTime timestamp() {
        return this.timestamp;
    }

    public Optional<ZonedDateTime> zeitpunkt() {
        return Optional.ofNullable(this.timestamp).map(TimestampedValue::jodaDateTimeToZonedDateTime);
    }

    public TimestampedValue createNewOfSameKind(ZonedDateTime timestamp, Optional<Double> value) {
        return new TimestampedValue(timestamp, value);
    }

    @Override
    public double wert() {
        if (this.istL\u00fccke()) {
            throw new UnzureichendeDatenlage("Wert f\u00fcr " + this.timestamp() + " ist nicht vorhanden.");
        }
        return this.value;
    }

    @Override
    public Optional<Double> vielleichtWert() {
        if (this.istL\u00fccke()) {
            return Optional.empty();
        }
        return Optional.of(this.wert());
    }

    @Override
    public boolean istL\u00fccke() {
        return Double.isNaN(this.value);
    }

    @Override
    public int compareTo(TimestampedValue that) {
        return Double.compare(this.wert(), that.wert());
    }

    public String toString() {
        return this.timestamp().toString() + " - " + this.wert();
    }

    public Optional<TimestampedValue> asOptional() {
        return TimestampedValue.toOptional(this);
    }

    public static Optional<TimestampedValue> toOptional(TimestampedValue timestampedValue) {
        if (timestampedValue != null) {
            if (!timestampedValue.istL\u00fccke()) {
                return Optional.of(timestampedValue);
            }
            if (timestampedValue.timestamp != null) {
                return Optional.of(timestampedValue);
            }
        }
        return Optional.empty();
    }

    public boolean onSameDayOfYearAs(Day day) {
        return this.timestamp.getMonthOfYear() == day.dateTime().getMonthOfYear() && this.timestamp.getDayOfMonth() == day.dateTime().getDayOfMonth();
    }
}

