/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.datenpr\u00fcfung;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import luwa.marlin.ship_library.model.datenpr\u00fcfung.Gepr\u00fcfterZeitbereich;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class Gepr\u00fcfteZeitbereiche {
    private final List<Gepr\u00fcfterZeitbereich> zusammengefassteZeitbereiche;

    public Gepr\u00fcfteZeitbereiche() {
        this(Collections.emptyList());
    }

    public Gepr\u00fcfteZeitbereiche(List<Gepr\u00fcfterZeitbereich> zeitbereiche) {
        this.zusammengefassteZeitbereiche = Gepr\u00fcfteZeitbereiche.fasseZusammen(zeitbereiche);
    }

    public boolean enthalten(Interval zeitbereich) {
        return this.zusammengefassteZeitbereiche.stream().anyMatch(gepr\u00fcfterZeitbereich -> this.intervalContainsInterval(gepr\u00fcfterZeitbereich.zeitbereich(), zeitbereich));
    }

    public boolean enthalten(DateTime zeitpunkt) {
        return this.zusammengefassteZeitbereiche.stream().anyMatch(gepr\u00fcfterZeitbereich -> gepr\u00fcfterZeitbereich.enth\u00e4lt(zeitpunkt));
    }

    private boolean intervalContainsInterval(Interval containingInterval, Interval containedInterval) {
        return containingInterval.contains(containedInterval.getStart()) && (containingInterval.contains(containedInterval.getEnd()) || containingInterval.getEnd().equals(containedInterval.getEnd()));
    }

    private static List<Gepr\u00fcfterZeitbereich> fasseZusammen(List<Gepr\u00fcfterZeitbereich> ranges) {
        Stack<Gepr\u00fcfterZeitbereich> stack = new Stack<Gepr\u00fcfterZeitbereich>();
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        ranges.sort(Comparator.comparing(a2 -> a2.zeitbereich().getStart()));
        stack.push(ranges.get(0));
        for (int i2 = 1; i2 < ranges.size(); ++i2) {
            Gepr\u00fcfterZeitbereich top = (Gepr\u00fcfterZeitbereich)stack.peek();
            Gepr\u00fcfterZeitbereich current = ranges.get(i2);
            if (top.zeitbereich().getEnd().isBefore(current.zeitbereich().getStart())) {
                stack.push(current);
                continue;
            }
            if (!top.zeitbereich().getEnd().isBefore(current.zeitbereich().getEnd())) continue;
            top = new Gepr\u00fcfterZeitbereich(new Interval((ReadableInstant)top.zeitbereich().getStart(), (ReadableInstant)current.zeitbereich().getEnd()));
            stack.pop();
            stack.push(top);
        }
        return stack;
    }
}

