/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import luwa.marlin.ship_library.model.Wertebereich;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Abflussjahresreihe;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.util.Buckets;
import luwa.marlin.ship_library.util.math.MaxFinder;
import luwa.marlin.ship_library.util.math.Meaner;
import luwa.marlin.ship_library.util.math.MinFinder;

public class TimeStampedValueCollection<T extends TimestampedValue> {
    private final List<T> werte;
    private final Buckets<YearMonth, T> yearMonthBuckets;
    private final Map<YearMonth, MaxFinder<T>> monthMaxFinders;
    private final Map<YearMonth, MinFinder<T>> monthMinFinders;
    private final Map<YearMonth, Meaner<T>> monthMeaners;
    private final Map<YearMonth, Boolean> monatVollst\u00e4ndig;
    private final NHNTransformationOfTimestampedValues transformOnAdd;
    private boolean vollst\u00e4ndigkeitGiltNichtMehr;
    private final Comparator<T> comparator;

    public TimeStampedValueCollection() {
        this(TimestampedValue::compareTo);
    }

    public TimeStampedValueCollection(NHNTransformationOfTimestampedValues transformOnAdd) {
        this(TimestampedValue::compareTo, transformOnAdd);
    }

    public TimeStampedValueCollection<T> CopyWithSameComparator() {
        return new TimeStampedValueCollection<T>(this.comparator);
    }

    public TimeStampedValueCollection(Comparator<T> comparator) {
        this(comparator, NHNTransformationOfTimestampedValues.doNothing());
    }

    public TimeStampedValueCollection(Comparator<T> comparator, NHNTransformationOfTimestampedValues transformOnAdd) {
        this.comparator = comparator;
        this.transformOnAdd = transformOnAdd;
        this.werte = new ArrayList<T>();
        this.yearMonthBuckets = new Buckets();
        this.monatVollst\u00e4ndig = new HashMap<YearMonth, Boolean>();
        this.vollst\u00e4ndigkeitGiltNichtMehr = true;
        this.monthMaxFinders = new HashMap<YearMonth, MaxFinder<T>>();
        this.monthMinFinders = new HashMap<YearMonth, MinFinder<T>>();
        this.monthMeaners = new HashMap<YearMonth, Meaner<T>>();
    }

    public Comparator<Double> werteVergleich(Function<Double, T> inklusion) {
        return (x2, y2) -> this.comparator.compare((TimestampedValue)inklusion.apply((Double)x2), (TimestampedValue)inklusion.apply((Double)y2));
    }

    public void add(T value) {
        this.vollst\u00e4ndigkeitGiltNichtMehr = true;
        T transformedValue = this.transformOnAdd.forValue(value);
        this.werte.add(transformedValue);
        YearMonth month = new YearMonth(((TimestampedValue)transformedValue).timestamp());
        this.yearMonthBuckets.add(month, transformedValue);
        this.maxFinder(month).add(transformedValue);
        this.minFinder(month).add(transformedValue);
        this.meaner(month).add(transformedValue);
    }

    public List<T> values() {
        return this.werte;
    }

    public SortedMap<YearMonth, Optional<T>> monthMax() {
        TreeMap<YearMonth, Optional<T>> monthMaxs = new TreeMap<YearMonth, Optional<T>>();
        for (YearMonth month : this.monthMaxFinders.keySet()) {
            Optional<T> max = this.monthMaxFinders.get(month).max();
            monthMaxs.put(month, max);
        }
        return monthMaxs;
    }

    public List<T> minimaDerMonate(Stream<YearMonth> monate) {
        MinFinder<T> minimaAllerMonate = new MinFinder<T>(this.comparator);
        monate.map(month -> this.minFinder((YearMonth)month).minima()).forEach(minimaAllerMonate::addAll);
        return minimaAllerMonate.minima();
    }

    public List<Double> ascendingValuesAsDoubles(Year year) {
        List<T> valuesAsTagesmittelwerte = this.desJahres(year);
        valuesAsTagesmittelwerte.sort(this.comparator);
        return valuesAsTagesmittelwerte.stream().map(TimestampedValue::wert).collect(Collectors.toList());
    }

    public T werteF\u00fcr(YearMonth month, int day) {
        return (T)((TimestampedValue)this.ofMonth(month).stream().filter(wert -> wert.timestamp().getDayOfMonth() == day).findFirst().orElse(null));
    }

    public List<T> ofMonth(YearMonth month) {
        return this.werteF\u00fcrMonat(month).collect(Collectors.toList());
    }

    public boolean monatVollst\u00e4ndig(YearMonth monat) {
        Boolean savedValue;
        if (this.vollst\u00e4ndigkeitGiltNichtMehr) {
            this.monatVollst\u00e4ndig.clear();
            this.vollst\u00e4ndigkeitGiltNichtMehr = false;
        }
        if ((savedValue = this.monatVollst\u00e4ndig.get(monat)) == null) {
            boolean istVollst\u00e4ndig = this.pr\u00fcfeVollst\u00e4ndigkeit(monat);
            this.monatVollst\u00e4ndig.put(monat, istVollst\u00e4ndig);
            return istVollst\u00e4ndig;
        }
        return savedValue;
    }

    private boolean pr\u00fcfeVollst\u00e4ndigkeit(YearMonth monat) {
        List<T> werteF\u00fcrMonat = this.yearMonthBuckets.get(monat);
        if (!this.thereIsAValueForEachDayOf(monat, werteF\u00fcrMonat)) {
            return false;
        }
        return this.numberOf(monat.days()) == werteF\u00fcrMonat.size();
    }

    private boolean thereIsAValueForEachDayOf(YearMonth month, List<T> werteF\u00fcrMonat) {
        Stream<Day> days = StreamSupport.stream(month.days().spliterator(), false);
        return days.allMatch(day -> werteF\u00fcrMonat.stream().anyMatch(wert -> wert.onSameDayOfYearAs((Day)day) && !wert.istL\u00fccke()));
    }

    private int numberOf(Iterable<Day> days) {
        int count = 0;
        for (Day ignored : days) {
            ++count;
        }
        return count;
    }

    public Stream<T> werteF\u00fcrMonatFallsVollst\u00e4ndig(YearMonth month) {
        if (this.monatVollst\u00e4ndig(month)) {
            return this.yearMonthBuckets.get(month).stream();
        }
        return Stream.empty();
    }

    public MaxFinder<T> maxFinder(YearMonth month) {
        MaxFinder<T> maxFinder = this.monthMaxFinders.get(month);
        if (null == maxFinder) {
            maxFinder = new MaxFinder<T>(this.comparator);
            this.monthMaxFinders.put(month, maxFinder);
        }
        return maxFinder;
    }

    public MinFinder<T> minFinder(YearMonth month) {
        MinFinder<T> minFinder = this.monthMinFinders.get(month);
        if (null == minFinder) {
            minFinder = new MinFinder<T>(this.comparator);
            this.monthMinFinders.put(month, minFinder);
        }
        return minFinder;
    }

    public Meaner<T> meaner(YearMonth month) {
        Meaner<Object> meaner = this.monthMeaners.get(month);
        if (null == meaner) {
            meaner = new Meaner();
            this.monthMeaners.put(month, meaner);
        }
        return meaner;
    }

    public Stream<T> werteF\u00fcrMonate(Stream<YearMonth> months) {
        return months.flatMap(month -> this.yearMonthBuckets.get((YearMonth)month).stream());
    }

    public Stream<T> werteF\u00fcrMonat(YearMonth month) {
        return this.yearMonthBuckets.get(month).stream();
    }

    public List<T> desMonats(YearMonth yearMonth) {
        return this.yearMonthBuckets.get(yearMonth);
    }

    public List<T> desJahres(Year year) {
        ArrayList<T> result = new ArrayList<T>();
        for (YearMonth month : year) {
            result.addAll(this.ofMonth(month));
        }
        return result;
    }

    public Optional<T> desTages(Day day) {
        T result = this.werteF\u00fcr(day.yearMonth(), day.day());
        if (result != null) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public boolean jahresreiheVollst\u00e4ndig(Abflussjahresreihe yearsRange, Ausfalljahre ausfalljahre) {
        return StreamSupport.stream(yearsRange.spliterator(), false).filter(abflussjahr -> !ausfalljahre.contain((Year)abflussjahr)).allMatch(abflussjahr -> abflussjahr.monate().get().allMatch(this::monatVollst\u00e4ndig));
    }

    public Abflussjahr firstAbflussjahr() {
        return new TreeSet<YearMonth>(this.yearMonthBuckets.keys()).first().abflussjahr();
    }

    public Wertebereich Wertebereich() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (TimestampedValue wert : this.werte) {
            if (wert.istL\u00fccke()) continue;
            double alsZahl = wert.wert();
            if (alsZahl < min) {
                min = alsZahl;
            }
            if (!(alsZahl > max)) continue;
            max = alsZahl;
        }
        return new Wertebereich(min, max, min != Double.MAX_VALUE && max != Double.MIN_VALUE);
    }
}

