/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.ZeitbereicheMitErg\u00e4nztenWerten;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.year.YearMonth;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class Tageswerte {
    private final Tagesmittelwerte tagesmittelwerte;
    private final ZeitbereicheMitErg\u00e4nztenWerten editedRanges;
    private final NHNTransformationOfTimestampedValues maybeNHNTransform;

    public Tageswerte(Tagesmittelwerte tagesmittelwerte, ZeitbereicheMitErg\u00e4nztenWerten editedRanges) {
        this(tagesmittelwerte, editedRanges, NHNTransformationOfTimestampedValues.doNothing());
    }

    public Tageswerte(Tagesmittelwerte tagesmittelwerte, ZeitbereicheMitErg\u00e4nztenWerten editedRanges, NHNTransformationOfTimestampedValues transformation) {
        this.tagesmittelwerte = tagesmittelwerte;
        this.editedRanges = editedRanges;
        this.maybeNHNTransform = transformation;
    }

    public Tagesmittelwert valueFor(YearMonth month, int day) {
        return this.maybeNHNTransform.forValue(this.tagesmittelwerte.valueFor(month, day));
    }

    public boolean istErg\u00e4nzt(Tagesmittelwert value) {
        Interval day = Tageswerte.dayIntervalFor(value.timestamp());
        return this.editedRanges.isEdited(day);
    }

    private static Interval dayIntervalFor(DateTime timestamp) {
        DateTime dayStart = timestamp.withMillisOfDay(0);
        DateTime dayEnd = new DateTime((Object)dayStart, DateTimeZone.forOffsetHours(1)).withTime(23, 59, 59, 999);
        return new Interval((ReadableInstant)dayStart, (ReadableInstant)dayEnd);
    }
}

