/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import luwa.marlin.ship_library.model.TimeStampedValueCollection;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Abflussjahresreihe;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.model.year.YearsRange;
import luwa.marlin.ship_library.util.math.Meaner;

public class Tagesmittelwerte {
    private final TimeStampedValueCollection<Tagesmittelwert> werte;

    public Tagesmittelwerte() {
        this(TimestampedValue::compareTo);
    }

    public Tagesmittelwerte(NHNTransformationOfTimestampedValues transformation) {
        this(TimestampedValue::compareTo, transformation);
    }

    public Tagesmittelwerte(Comparator<Tagesmittelwert> comparator) {
        this(comparator, NHNTransformationOfTimestampedValues.doNothing());
    }

    public Tagesmittelwerte(Comparator<Tagesmittelwert> comparator, NHNTransformationOfTimestampedValues transformation) {
        this(new TimeStampedValueCollection<Tagesmittelwert>(comparator, transformation));
    }

    private Tagesmittelwerte(TimeStampedValueCollection<Tagesmittelwert> werte) {
        this.werte = werte;
    }

    public TimeStampedValueCollection<Tagesmittelwert> werte() {
        return this.werte;
    }

    public void add(Tagesmittelwert value) {
        this.werte().add(value);
    }

    public List<Tagesmittelwert> values() {
        return this.werte().values();
    }

    public Optional<Tagesmittelwert> ofDay(Day day) {
        return this.werte().desTages(day);
    }

    public List<Tagesmittelwert> ofMonth(YearMonth month) {
        return this.werte().ofMonth(month);
    }

    public List<Double> orderedAsDoubles(Year year) {
        return this.werte().ascendingValuesAsDoubles(year);
    }

    public Comparator<Double> werteVergleich() {
        ZonedDateTime festerWillk\u00fcrlicherZeitpunkt = ZonedDateTime.of(2010, 1, 1, 0, 0, 0, 0, ZoneId.of("GMT"));
        return this.werte.werteVergleich(x2 -> new Tagesmittelwert(festerWillk\u00fcrlicherZeitpunkt, Optional.ofNullable(x2)));
    }

    public List<Tagesmittelwert> ascending(YearsRange<? extends Year> years) {
        return this.values().stream().filter(value -> {
            if (!value.istL\u00fccke()) {
                return years.interval().contains(value.timestamp());
            }
            return false;
        }).sorted().collect(Collectors.toList());
    }

    public Tagesmittelwert valueFor(YearMonth month, int day) {
        return this.werte().werteF\u00fcr(month, day);
    }

    public Tagesmittelwert yearWinterNW(Abflussjahr year) {
        return this.monthsNW_single(year.winter());
    }

    public Stream<? extends TimestampedValue> werteF\u00fcrVollst\u00e4ndigeMonate(Stream<YearMonth> months) {
        return months.flatMap(this::werteF\u00fcrMonatFallsVollst\u00e4ndig);
    }

    public Stream<? extends TimestampedValue> werteF\u00fcrMonatFallsVollst\u00e4ndig(YearMonth month) {
        return this.werte().werteF\u00fcrMonatFallsVollst\u00e4ndig(month);
    }

    public Tagesmittelwert yearSummerNW(Abflussjahr year) {
        return this.monthsNW_single(year.summer());
    }

    public List<Tagesmittelwert> yearNW(Year year) {
        return this.monthsNW(year);
    }

    public Tagesmittelwert monthsNW_single(Iterable<YearMonth> months) {
        List<Tagesmittelwert> nws = this.monthsNW(months);
        if (nws.isEmpty()) {
            return null;
        }
        return nws.get(0);
    }

    public List<Tagesmittelwert> monthsNW(Iterable<YearMonth> months) {
        return this.werte().minimaDerMonate(StreamSupport.stream(months.spliterator(), false));
    }

    public TimestampedValue yearWinterMW(Abflussjahr year) {
        return this.monthsMW(year.winter());
    }

    public TimestampedValue yearSummerMW(Abflussjahr year) {
        return this.monthsMW(year.summer());
    }

    public TimestampedValue yearMW(Year year) {
        return this.monthsMW(year);
    }

    public TimestampedValue mw(Abflussjahresreihe yearsRange) {
        return this.monthsMW(yearsRange.allMonths());
    }

    public TimestampedValue monthsMW(Iterable<YearMonth> months) {
        Meaner<Tagesmittelwert> meaner = new Meaner<Tagesmittelwert>();
        for (YearMonth month : months) {
            meaner.add(this.werte().meaner(month));
        }
        return meaner.mean();
    }

    public List<Double> sortierteWerteImZeitraum(Abflussjahresreihe yearsRange, Ausfalljahre ausfalljahre) {
        ArrayList<Double> sortierteMittlereWerte = new ArrayList<Double>();
        for (Abflussjahr jahr : yearsRange) {
            if (ausfalljahre.contain(jahr)) continue;
            List<Tagesmittelwert> werteImJahr = this.ofYear(jahr);
            sortierteMittlereWerte.addAll(werteImJahr.stream().map(TimestampedValue::wert).collect(Collectors.toList()));
        }
        Collections.sort(sortierteMittlereWerte);
        return sortierteMittlereWerte;
    }

    private List<Tagesmittelwert> ofYear(Year year) {
        return this.werte().desJahres(year);
    }

    public boolean jahresreiheVollst\u00e4ndig(Abflussjahresreihe yearsRange, Ausfalljahre ausfalljahre) {
        return this.werte().jahresreiheVollst\u00e4ndig(yearsRange, ausfalljahre);
    }

    public Optional<Tagesmittelwert> desTages(Day day) {
        return this.werte().desTages(day);
    }

    public void addAll(Tagesmittelwerte tagesmittelwerte) {
        for (Tagesmittelwert v2 : tagesmittelwerte.values()) {
            this.add(v2);
        }
    }

    public static Tagesmittelwerte without(Tagesmittelwerte tagesmittelwerte, Predicate<Tagesmittelwert> predicate) {
        Tagesmittelwerte result = new Tagesmittelwerte(tagesmittelwerte.werte.CopyWithSameComparator());
        tagesmittelwerte.values().stream().filter(predicate.negate()).forEach(result::add);
        return result;
    }

    public Abflussjahr firstAbflussjahr() {
        return this.werte().firstAbflussjahr();
    }

    public boolean monatVollst\u00e4ndig(YearMonth yearMonth) {
        return this.werte().monatVollst\u00e4ndig(yearMonth);
    }
}

