/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import luwa.marlin.ship_library.model.value.Value;
import luwa.marlin.ship_library.util.Format;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Parameter {
    w("Wasserstand", "Wasserst\u00e4nde", "Wasserstandsdaten", "W", "cm"){

        @Override
        public String formatValue(Value value) {
            if (null == value || value.istL\u00fccke()) {
                return "";
            }
            return String.valueOf(Math.round(value.wert()));
        }

        @Override
        public String formatValuePadded(Value value) {
            return this.formatValue(value);
        }

        @Override
        public double maybeRound(double value) {
            return Math.round(value);
        }

        @Override
        public String valueColumnName() {
            return "w";
        }

        @Override
        public String key() {
            return "w";
        }

        @Override
        public String table() {
            return "w";
        }

        @Override
        public String table_stundenmittel() {
            return "v_w_stundenmittel";
        }

        @Override
        public String table_tagesmittel() {
            return "v_w_tagesmittel";
        }

        @Override
        public String table_max() {
            return "w_max";
        }

        @Override
        public String table_max_view() {
            return "v_w_tagesmaxima";
        }

        @Override
        public String table_scheitel() {
            return "w_scheitel";
        }

        @Override
        public String table_haupt() {
            return "w_haupt";
        }

        @Override
        public String table_redundanz() {
            return "w_redundanzsystem";
        }

        @Override
        public String table_tagesmittel_redundanz() {
            return "v_w_tagesmittel_redundanz";
        }

        @Override
        public String table_max_redundanz() {
            return "w_max_redundanz";
        }

        @Override
        public String table_pruefung() {
            return "w_pruefung";
        }

        @Override
        public String table_updates() {
            return "w_updates";
        }

        @Override
        public String table_hand() {
            return "w_hand_haupt";
        }

        @Override
        public String table_system() {
            return "w_system_haupt";
        }

        @Override
        public String table_hand_redundanz() {
            return "w_hand_redundanz";
        }

        @Override
        public String table_system_redundanz() {
            return "w_system_redundanz";
        }

        @Override
        public String table_temp() {
            return "w_temp_reihen";
        }

        @Override
        public String table_temp_definition() {
            return "w_temp_reihen_definition";
        }

        @Override
        public String updates_reihe() {
            return "w";
        }
    }
    ,
    q("Abfluss", "Abfl\u00fcsse", "Abflussdaten", "Q", "m\u00b3/s"){
        private static final String figureSpace = "  ";
        private static final String commaSpace = " ";

        @Override
        public String formatValue(Value value) {
            if (null == value || value.istL\u00fccke()) {
                return "";
            }
            BigDecimal bd = BigDecimal.valueOf(value.wert());
            if ((bd = bd.round(new MathContext(3))).doubleValue() < 1.0) {
                return new DecimalFormat("0.000").format(bd).replace('.', ',');
            }
            if (bd.doubleValue() < 10.0) {
                return new DecimalFormat("#.00").format(bd).replace('.', ',');
            }
            if (bd.doubleValue() < 100.0) {
                return new DecimalFormat("##.0").format(bd).replace('.', ',');
            }
            return bd.toPlainString().replace('.', ',');
        }

        @Override
        public String formatValuePadded(Value value) {
            String formatted = this.formatValue(value);
            Object rightPad = commaSpace + Format.repeat(figureSpace, 3);
            int indexOfComma = formatted.indexOf(",");
            if (indexOfComma >= 0) {
                rightPad = Format.repeat(figureSpace, 3 - (formatted.length() - indexOfComma - 1));
            }
            return formatted + (String)rightPad;
        }

        @Override
        public double maybeRound(double value) {
            return value;
        }

        @Override
        public String valueColumnName() {
            return "q";
        }

        @Override
        public String key() {
            return "q";
        }

        @Override
        public String table() {
            return "q";
        }

        @Override
        public String table_stundenmittel() {
            return "v_q_stundenmittel";
        }

        @Override
        public String table_tagesmittel() {
            return "v_q_tagesmittel";
        }

        @Override
        public String table_max() {
            return "q_max";
        }

        @Override
        public String table_max_view() {
            return "v_q_tagesmaxima";
        }

        @Override
        public String table_scheitel() {
            return "q_scheitel";
        }

        @Override
        public String table_haupt() {
            return "q_haupt";
        }

        @Override
        public String table_redundanz() {
            return "q_redundanz";
        }

        @Override
        public String table_tagesmittel_redundanz() {
            return "v_q_tagesmittel_redundanz";
        }

        @Override
        public String table_max_redundanz() {
            return "q_max_redundanz";
        }

        @Override
        public String table_pruefung() {
            return "q_pruefung";
        }

        @Override
        public String table_updates() {
            return "q_updates";
        }

        @Override
        public String table_hand() {
            return "q_hand_haupt";
        }

        @Override
        public String table_system() {
            return "q_system_haupt";
        }

        @Override
        public String table_hand_redundanz() {
            return "q_hand_redundanz";
        }

        @Override
        public String table_system_redundanz() {
            return "q_system_redundanz";
        }

        @Override
        public String table_temp() {
            return "q_temp_reihen";
        }

        @Override
        public String table_temp_definition() {
            return "q_temp_reihen_definition";
        }

        @Override
        public String updates_reihe() {
            return "q";
        }
    };

    private static final DecimalFormat decimalFormat;
    private final String nameSingular;
    private final String namePlural;
    private final String nameData;
    private final String symbol;
    private final String unit;
    protected static final DecimalFormat germanFormat;

    private Parameter(String nameSingular, String namePlural, String nameData, String symbol, String unit) {
        this.nameSingular = nameSingular;
        this.namePlural = namePlural;
        this.nameData = nameData;
        this.symbol = symbol;
        this.unit = unit;
    }

    public String nameSingular() {
        return this.nameSingular;
    }

    public String namePlural() {
        return this.namePlural;
    }

    public String nameData() {
        return this.nameData;
    }

    public String symbol() {
        return this.symbol;
    }

    public String unit() {
        return this.unit;
    }

    public abstract String formatValue(Value var1);

    public abstract String formatValuePadded(Value var1);

    public abstract double maybeRound(double var1);

    public abstract String valueColumnName();

    public abstract String key();

    public abstract String table();

    public abstract String table_stundenmittel();

    public abstract String table_tagesmittel();

    public abstract String table_max();

    public abstract String table_max_view();

    public abstract String table_scheitel();

    public abstract String table_haupt();

    public abstract String table_redundanz();

    public abstract String table_tagesmittel_redundanz();

    public abstract String table_max_redundanz();

    public abstract String table_pruefung();

    public abstract String table_updates();

    public abstract String table_hand();

    public abstract String table_system();

    public abstract String table_hand_redundanz();

    public abstract String table_system_redundanz();

    public abstract String table_temp();

    public abstract String table_temp_definition();

    public abstract String updates_reihe();

    private static DecimalFormat decimalFormatFor(String pattern) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.GERMANY);
        format.applyPattern(pattern);
        return format;
    }

    static {
        decimalFormat = Parameter.decimalFormatFor("#.###");
        germanFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.GERMAN);
    }
}

