/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.ArrayList;
import java.util.List;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.YearMonth;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class Monatsmittelwerte {
    private final Tagesmittelwerte werte;
    private final Interval interval;

    public Monatsmittelwerte(Tagesmittelwerte werte, Interval interval) {
        this.werte = werte;
        this.interval = interval;
    }

    public List<TimestampedValue> values() {
        ArrayList<TimestampedValue> result = new ArrayList<TimestampedValue>();
        for (YearMonth month : YearMonth.monateIn(this.interval)) {
            if (month.istAktuellerMonat()) continue;
            DateTime zeitpunktImMonat = month.interval().getStart();
            if (this.werte.monatVollst\u00e4ndig(month)) {
                double mittel = this.werte.werte().meaner((YearMonth)month).mean().value;
                result.add(new TimestampedValue(zeitpunktImMonat, mittel));
                continue;
            }
            result.add(new TimestampedValue(zeitpunktImMonat));
        }
        return result;
    }
}

