/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;

public enum Messart {
    undefiniert("undefined", 0, 0, "Unbekannt", ""),
    vielpunktmessung("multiPoint", 1, 1, "Vielpunktmessung Fl\u00fcgel/Impulsmessung", "free-point measurement"),
    zweipunktmessungAmerikanischeMethode("twoPointAmerican", 2, 2, "Zweipunktmessung (amerikanische Methode)", ""),
    zweipunktmessungKrepsMessmethode("twoPointKreps", 3, 5, "Zweipunktmessung (Kreps-Messmethode)", "2-point measurement"),
    einpunktmessung("one_point", 4, 3, "Einpunktmessung", ""),
    vielpunktmessungMitKrepspunkt("undefined", 5, 4, "Vielpunktmessung mit Krepspunkt", ""),
    oberfl\u00e4chenmessung("surface", 6, 6, "Oberfl\u00e4chenmessung", ""),
    ablaufmessung("tracer", 7, 7, "Ablaufmessung", ""),
    dreipunktmessung("threePoint", 8, 8, "3-Punktmessung", ""),
    f\u00fcnfpunktmessung("fivePoint", 9, 9, "5-Punktmessung", ""),
    sechspunktmessung("sixPoint", 10, 10, "6-Punktmessung", ""),
    tracerIntegration("tracerIntegration", 11, 11, "Tracer Integration", ""),
    tracerKontinuierlich("tracerContinuous", 12, 12, "Tracer Kontinuierlich", ""),
    ADCP("adcp", 13, 999, "ADCP", ""),
    gemischt("mixed", 14, 99, "gemischt", ""),
    vielpunktmessungADCP_Ultraschall("multiPointADCP", 15, 2222, "Vielpunktmessung ADCP/Ultraschall", ""),
    vielpunktmessungADCP_UltraschallSchleifenfahrt("multiPointADCPLoop", 16, 3333, "Vielpunktmessung ADCP/Ultraschall Schleifenfahrt", ""),
    sectionBySectionADCP_ADC("sectionBySection", 17, 4444, "Section by section ADCP/ADC", ""),
    magnetischInduktiv("magnetic", 18, 7777, "Magnetisch induktiv", ""),
    voMitRadar("voRadar", 19, 8888, "Oberfl\u00e4chengeschwindigkeit vo mit Radar", ""),
    voOptisch("voOptical", 20, 9999, "Oberfl\u00e4chengeschwindigkeit vo optisch", "");

    private final String key;
    private final int databaseId;
    private final int importDatabaseId;
    private final String description;
    private final String importName;

    private Messart(String key, int databaseId, int importDatabaseId, String description, String importName) {
        this.key = key;
        this.databaseId = databaseId;
        this.importDatabaseId = importDatabaseId;
        this.description = description;
        this.importName = importName;
    }

    public String key() {
        return this.key;
    }

    public int databaseId() {
        return this.databaseId;
    }

    public int importDatabaseId() {
        return this.importDatabaseId;
    }

    public String beschreibung() {
        return this.description;
    }

    public static Messart fromDb(int databaseId) {
        for (Messart v2 : Messart.values()) {
            if (v2.databaseId != databaseId) continue;
            return v2;
        }
        throw new NoSuchElementException("Lotrechte mit Messart " + databaseId + " wird nicht unterst\u00fctzt");
    }

    public static Messart fromImportDb(int importDatabaseId) {
        for (Messart v2 : Messart.values()) {
            if (v2.importDatabaseId != importDatabaseId) continue;
            return v2;
        }
        throw new NoSuchElementException("Lotrechte mit importierter Messart " + importDatabaseId + " wird nicht unterst\u00fctzt");
    }

    public static Messart fromImportName(String importName) {
        for (Messart v2 : Messart.values()) {
            if (!v2.importName.equals(importName)) continue;
            return v2;
        }
        throw new NoSuchElementException("Lotrechte mit importierter Messart " + importName + " wird nicht unterst\u00fctzt");
    }

    public static Optional<Messart> fromKey(String key) {
        return Arrays.stream(Messart.values()).filter(it -> it.key().equals(key)).findFirst();
    }

    public boolean istZweipunktmessung() {
        return Arrays.asList(zweipunktmessungAmerikanischeMethode, zweipunktmessungKrepsMessmethode).contains((Object)this);
    }
}

