/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.Optional;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.JahrbuchModus;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Abflussjahresreihe;
import luwa.marlin.ship_library.model.year.CalendarYearsRange;
import luwa.marlin.ship_library.model.year.ErweitertesJahr;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import org.joda.time.DateTime;

public class JahrbuchseitenConfiguration {
    private final DateTime erstellungsdatum = new DateTime();
    private final long messstellenNummer;
    private final int anfangsjahrZeitreihe;
    private final int endjahrZeitreihe;
    private final Optional<Long> userId;
    private final JahrbuchModus modus;
    private final AbflussOderWasserstand QoderW;
    private final int jahr;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;

    public JahrbuchseitenConfiguration(long messstellenNummer, Optional<Long> benutzerId, int vonJahr, int bisJahr, AbflussOderWasserstand abflussOderWasserstand, JahrbuchModus modus, Optional<Integer> jahr) {
        this(messstellenNummer, benutzerId, vonJahr, bisJahr, abflussOderWasserstand, modus, jahr, WasserstandBezugsh\u00f6he.Centimeter\u00dcberAktuellemPegelnullpunkt);
    }

    public AbflussOderWasserstand abflussOderWasserstand() {
        return this.QoderW;
    }

    public long messstellenNummer() {
        return this.messstellenNummer;
    }

    public int anfangsjahrZeitreihe() {
        return this.anfangsjahrZeitreihe;
    }

    public int endjahrZeitreihe() {
        return this.endjahrZeitreihe;
    }

    public Parameter parameter() {
        return this.abflussOderWasserstand().toParameter();
    }

    public String einheit() {
        switch (this.QoderW) {
            case Q: {
                return "m\u00b3/s";
            }
            case W: {
                return this.abflussOderWasserstand().einheitKurz(this.wasserstandBezugsh\u00f6he);
            }
        }
        throw new IllegalArgumentException(this.QoderW.toString());
    }

    public JahrbuchseitenConfiguration(long messstellenNummer, Optional<Long> userId, int anfangsjahrZeitreihe, int endjahrZeitreihe, AbflussOderWasserstand QoderW) {
        this(messstellenNummer, userId, anfangsjahrZeitreihe, endjahrZeitreihe, QoderW, endjahrZeitreihe);
    }

    public JahrbuchseitenConfiguration(long messstellenNummer, Optional<Long> userId, int anfangsjahrZeitreihe, int endjahrZeitreihe, AbflussOderWasserstand QoderW, int jahr) {
        this(messstellenNummer, userId, anfangsjahrZeitreihe, endjahrZeitreihe, QoderW, JahrbuchModus.nachRichtlinie, Optional.of(jahr));
    }

    public JahrbuchseitenConfiguration(long messstellenNummer, Optional<Long> userId, int anfangsjahrZeitreihe, int endjahrZeitreihe, AbflussOderWasserstand QoderW, JahrbuchModus modus, Optional<Integer> jahr, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.messstellenNummer = messstellenNummer;
        this.anfangsjahrZeitreihe = anfangsjahrZeitreihe;
        this.endjahrZeitreihe = endjahrZeitreihe;
        this.QoderW = QoderW;
        this.modus = modus;
        this.jahr = jahr.orElse(endjahrZeitreihe);
        this.userId = userId;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
    }

    public int jahr() {
        return this.jahr;
    }

    public Abflussjahr abflussjahr() {
        return new Abflussjahr(this.jahr());
    }

    public Kalenderjahr kalenderjahr() {
        return new Kalenderjahr(this.jahr());
    }

    public ErweitertesJahr erweitertesJahr() {
        return new ErweitertesJahr(this.jahr());
    }

    public Abflussjahresreihe hydrologicalYearsRange() {
        return new Abflussjahresreihe(this.anfangsjahrZeitreihe, this.endjahrZeitreihe);
    }

    public CalendarYearsRange calendarYearsRange() {
        return new CalendarYearsRange(this.anfangsjahrZeitreihe, this.endjahrZeitreihe);
    }

    public DateTime sp\u00e4testerBetrachteterZeitpunkt() {
        if (this.jahr >= this.endjahrZeitreihe) {
            return new Kalenderjahr(this.jahr).endmonat().endOfMonth();
        }
        return new Kalenderjahr(this.endjahrZeitreihe).endmonat().endOfMonth();
    }

    public JahrbuchModus modus() {
        return this.modus;
    }

    public Optional<Long> userId() {
        return this.userId;
    }

    public DateTime erstellungsdatum() {
        return this.erstellungsdatum;
    }

    public WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he() {
        return this.wasserstandBezugsh\u00f6he;
    }
}

