/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.DatenF\u00fcrJahrbuchseite;
import luwa.marlin.ship_library.model.Dauertabelle;
import luwa.marlin.ship_library.model.Extremwert;
import luwa.marlin.ship_library.model.Extremwerte;
import luwa.marlin.ship_library.model.Hauptwerte;
import luwa.marlin.ship_library.model.JahrbuchModus;
import luwa.marlin.ship_library.model.JahrbuchseitenConfiguration;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Pegelnullpunktwechsel;
import luwa.marlin.ship_library.model.Scheitelwerte;
import luwa.marlin.ship_library.model.Tagesh\u00f6chstwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.Tageswerte;
import luwa.marlin.ship_library.model.units.Units;
import luwa.marlin.ship_library.model.value.Scheitelwert;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.CalendarYearsRange;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.ExtremwerteRenderModel;
import org.joda.time.DateTime;
import tech.units.indriya.quantity.Quantities;

public class Jahrbuchseite {
    private final Messstelle messstelle;
    private final DateTime anfangDerAufzeichnungen;
    private final Tageswerte tageswerte;
    private final Hauptwerte hauptwerte;
    private final Extremwerte extremwerte;
    private final Dauertabelle dauertabelle;
    private final Ausfalljahre ausfalljahre;
    private final String allgemeineBemerkung;
    private final Pegelnullpunktwechsel pegelnullpunktwechsel;
    private final Optional<Tagesmittelwerte> tagesmittelwerteW;
    private final boolean abflussspendeBerechnen;
    private final Optional<Tagesh\u00f6chstwerte> tagesh\u00f6chstwerteW;
    private final Optional<Scheitelwerte> scheitelwerteW;
    private final Optional<Benutzer> benutzer;
    private final JahrbuchseitenConfiguration configuration;

    public Jahrbuchseite(JahrbuchseitenConfiguration config, DatenRepository datenRepository) throws Exception {
        this.configuration = config;
        DatenF\u00fcrJahrbuchseite daten = new DatenF\u00fcrJahrbuchseite(config, datenRepository);
        this.anfangDerAufzeichnungen = daten.anfangDerAufzeichnungen();
        this.messstelle = daten.messstelle();
        this.ausfalljahre = daten.ausfalljahre();
        this.benutzer = daten.benutzer();
        this.scheitelwerteW = daten.scheitelwerteW();
        this.tagesmittelwerteW = daten.tagesmittelwerteW();
        this.tagesh\u00f6chstwerteW = daten.tagesh\u00f6chstwerteW();
        this.abflussspendeBerechnen = daten.abflussspendeSollBerechnetWerden();
        this.pegelnullpunktwechsel = daten.pegelnullpunktwechsel();
        this.tageswerte = daten.tageswerte();
        this.hauptwerte = daten.hauptwerte();
        this.extremwerte = daten.extremwerte();
        this.dauertabelle = daten.dauertabelle();
        this.allgemeineBemerkung = daten.allgemeineBemerkung();
    }

    public JahrbuchseitenConfiguration configuration() {
        return this.configuration;
    }

    public Stream<Optional<Extremwert>> extremwerteH() {
        List<Scheitelwert> werte = this.extremwerte().extremwerteH(new CalendarYearsRange(this.configuration().anfangsjahrZeitreihe(), this.configuration().endjahrZeitreihe()));
        return this.asStreamOfExtremwerte(werte, ExtremwerteRenderModel.HochOderNiedrigwasser.Hochwasser);
    }

    private Stream<Optional<Extremwert>> asStreamOfExtremwerte(List<? extends TimestampedValue> werte, ExtremwerteRenderModel.HochOderNiedrigwasser hochOderNiedrigwasser) {
        return IntStream.range(0, 10).mapToObj(n2 -> {
            if (n2 >= werte.size()) {
                return Optional.empty();
            }
            switch (this.configuration().abflussOderWasserstand()) {
                case Q: {
                    TimestampedValue wert = (TimestampedValue)werte.get(n2);
                    DateTime zeitpunkt = wert.timestamp();
                    return Optional.of(new Extremwert(wert, this.hauptwerte.calculateRate(wert, this.messstelle.fl\u00e4cheEinzugsgebietInQuadratkilometer()).map(TimestampedValue::wert).map(result -> Quantities.getQuantity(result, Units.LITRE_PER_SECOND_TIMES_SQUARE_KILOMETRE)), this.extremwerte.extremWasserstandInSpalte(zeitpunkt, hochOderNiedrigwasser)));
                }
                case W: {
                    return Optional.of(new Extremwert((TimestampedValue)werte.get(n2)));
                }
            }
            throw new IllegalStateException("Unexpected value: " + this.configuration().abflussOderWasserstand());
        });
    }

    public Stream<Optional<Extremwert>> extremwerteN() {
        List<Tagesmittelwert> werte = this.extremwerte().extremwerteNnachRichtlinie(new CalendarYearsRange(this.configuration().anfangsjahrZeitreihe(), this.configuration().endjahrZeitreihe()));
        return this.asStreamOfExtremwerte(werte, ExtremwerteRenderModel.HochOderNiedrigwasser.Niedrigwasser);
    }

    public DateTime anfangDerAufzeichnungen() {
        return this.anfangDerAufzeichnungen;
    }

    public Dauertabelle dauertabelle() {
        return this.dauertabelle;
    }

    public Ausfalljahre outageYears() {
        return this.ausfalljahre;
    }

    public Pegelnullpunktwechsel zeroPointChanges() {
        return this.pegelnullpunktwechsel;
    }

    public String allgemeineBemerkung() {
        return this.allgemeineBemerkung;
    }

    public boolean nachRichtlinie() {
        return this.configuration().modus().equals((Object)JahrbuchModus.nachRichtlinie);
    }

    public Optional<Tagesmittelwerte> tagesmittelwerteW() {
        return this.tagesmittelwerteW;
    }

    public Optional<Tagesh\u00f6chstwerte> tagesh\u00f6chstwerteW() {
        return this.tagesh\u00f6chstwerteW;
    }

    public boolean abflussspendeBerechnen() {
        return this.abflussspendeBerechnen;
    }

    public Tageswerte tageswerte() {
        return this.tageswerte;
    }

    public Pegelnullpunktwechsel pegelnullpunktwechsel() {
        return this.pegelnullpunktwechsel;
    }

    public Optional<Benutzer> benutzer() {
        return this.benutzer;
    }

    public Messstelle messstelle() {
        return this.messstelle;
    }

    public Hauptwerte hauptwerte() {
        return this.hauptwerte;
    }

    public Extremwerte extremwerte() {
        return this.extremwerte;
    }

    public Optional<Scheitelwert> scheitelAt(DateTime day) {
        return this.scheitelwerteW.flatMap(scheitelW -> scheitelW.ofDay(new Day(day)));
    }
}

