/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import luwa.marlin.ship_library.model.Abflusshalbjahr;
import luwa.marlin.ship_library.model.Scheitelwerte;
import luwa.marlin.ship_library.model.Tagesh\u00f6chstwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.TimeStampedValueCollection;
import luwa.marlin.ship_library.model.value.Tagesh\u00f6chstwert;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.model.year.YearsRange;
import luwa.marlin.ship_library.util.OptionalMitMarkierung;
import luwa.marlin.ship_library.util.math.MaxFinder;
import luwa.marlin.ship_library.util.math.Meaner;
import luwa.marlin.ship_library.util.math.MinFinder;

public class Hauptwerte {
    private final Tagesmittelwerte tagesmittelwerte;
    private final Tagesh\u00f6chstwerte tagesh\u00f6chstwerte;
    private final Scheitelwerte alleScheitelwerte;
    private final Tagesmittelwerte alleTagesmittel;
    private final Ausfalljahre ausfalljahre;
    private final Tagesh\u00f6chstwerte tagesh\u00f6chstwerteAuchAusfalljahre;
    private final Tagesmittelwerte tagesmittelwerteAuchAusfalljahre;

    public Hauptwerte(Tagesmittelwerte tagesmittelwerteAuchAusfalljahre, Tagesh\u00f6chstwerte tagesh\u00f6chstwerteAuchAusfalljahre, Scheitelwerte alleScheitelwerte, Tagesmittelwerte alleTagesmittel, Ausfalljahre ausfalljahre) {
        this.tagesmittelwerte = Tagesmittelwerte.without(tagesmittelwerteAuchAusfalljahre, ausfalljahre::contain);
        this.tagesmittelwerteAuchAusfalljahre = tagesmittelwerteAuchAusfalljahre;
        this.tagesh\u00f6chstwerte = Tagesh\u00f6chstwerte.without(tagesh\u00f6chstwerteAuchAusfalljahre, ausfalljahre::contain);
        this.tagesh\u00f6chstwerteAuchAusfalljahre = tagesh\u00f6chstwerteAuchAusfalljahre;
        this.alleScheitelwerte = alleScheitelwerte;
        this.alleTagesmittel = alleTagesmittel;
        this.ausfalljahre = ausfalljahre;
    }

    public List<? extends TimestampedValue> monatswert(YearMonth month, Art art) {
        switch (art) {
            case H: {
                return this.monatsh\u00f6chstwert(month);
            }
            case M: {
                return List.of(new Meaner<Tagesmittelwert>(this.tagesmittelwerteAuchAusfalljahre.werte().werteF\u00fcrMonatFallsVollst\u00e4ndig(month)).mean());
            }
            case N: {
                return this.monatsniedrigwert(month);
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + art);
    }

    private List<? extends TimestampedValue> monatsh\u00f6chstwert(YearMonth month) {
        return new MaxFinder<TimestampedValue>(this.tagesh\u00f6chstwerteAuchAusfalljahre.werteF\u00fcrMonatFallsVollst\u00e4ndig(month)).maxima();
    }

    private List<? extends TimestampedValue> monatsniedrigwert(YearMonth month) {
        TimeStampedValueCollection<Tagesmittelwert> werte = this.tagesmittelwerteAuchAusfalljahre.werte();
        if (werte.monatVollst\u00e4ndig(month)) {
            return werte.minFinder(month).minima();
        }
        return List.of();
    }

    public OptionalMitMarkierung<? extends TimestampedValue> mehrj\u00e4hrigerMonatswert(YearsRange<? extends Year> yearsRange, int month, Art art) {
        Stream<YearMonth> monate = yearsRange.monate(month);
        switch (art) {
            case N: {
                Stream<TimestampedValue> niedrigwerte = monate.filter(this.tagesmittelwerteAuchAusfalljahre::monatVollst\u00e4ndig).map(monat -> this.monatsniedrigwert((YearMonth)monat).get(0));
                return new OptionalMitMarkierung<TimestampedValue>(new MinFinder<TimestampedValue>(niedrigwerte).minima());
            }
            case MN: {
                return new OptionalMitMarkierung<TimestampedValue>(new Meaner<TimestampedValue>(monate.filter(this.tagesmittelwerteAuchAusfalljahre::monatVollst\u00e4ndig).map(monat -> this.monatsniedrigwert((YearMonth)monat).get(0))).mean());
            }
            case M: {
                return new OptionalMitMarkierung<TimestampedValue>(new Meaner<TimestampedValue>(this.tagesmittelwerteAuchAusfalljahre.werteF\u00fcrVollst\u00e4ndigeMonate(monate)).mean());
            }
            case MH: {
                return new OptionalMitMarkierung<TimestampedValue>(new Meaner<TimestampedValue>(monate.filter(this.tagesh\u00f6chstwerteAuchAusfalljahre::monatVollst\u00e4ndig).map(monat -> this.monatsh\u00f6chstwert((YearMonth)monat).get(0))).mean());
            }
            case H: {
                Stream<TimestampedValue> h\u00f6chstwerte = monate.filter(this.tagesh\u00f6chstwerteAuchAusfalljahre::monatVollst\u00e4ndig).map(monat -> this.monatsh\u00f6chstwert((YearMonth)monat).get(0));
                return new OptionalMitMarkierung<TimestampedValue>(new MaxFinder<TimestampedValue>(h\u00f6chstwerte).maxima());
            }
        }
        throw new IllegalStateException("Unexpected value: " + art);
    }

    public Optional<TimestampedValue> calculateRate(TimestampedValue q2, Double drainageBasinSize) {
        if (null == q2 || q2.istL\u00fccke() || drainageBasinSize == null || drainageBasinSize == 0.0) {
            return Optional.empty();
        }
        return Optional.of(new TimestampedValue(q2.timestamp(), q2.wert() * 1000.0 / drainageBasinSize));
    }

    public OptionalMitMarkierung<? extends TimestampedValue> HH() {
        List<TimestampedValue> list = this.alleScheitelwerte.values().isEmpty() ? this.tagesh\u00f6chstwerte.values() : this.alleScheitelwerte.values();
        return new OptionalMitMarkierung(new MaxFinder(list.stream()).maxima());
    }

    public OptionalMitMarkierung<Tagesmittelwert> NN() {
        return new OptionalMitMarkierung<Tagesmittelwert>(new MinFinder(this.alleTagesmittel.values().stream()).minima());
    }

    public Optional<TimestampedValue> jahresHalbjahrwert(Abflussjahr jahr, Art art, Abflusshalbjahr halbjahr) {
        switch (art) {
            case N: {
                switch (halbjahr) {
                    case sommer: {
                        return TimestampedValue.toOptional(this.tagesmittelwerte.yearSummerNW(jahr));
                    }
                    case winter: {
                        return TimestampedValue.toOptional(this.tagesmittelwerte.yearWinterNW(jahr));
                    }
                }
                throw new IllegalStateException("Unexpected value: " + halbjahr);
            }
            case M: {
                switch (halbjahr) {
                    case sommer: {
                        return TimestampedValue.toOptional(this.tagesmittelwerte.yearSummerMW(jahr));
                    }
                    case winter: {
                        return TimestampedValue.toOptional(this.tagesmittelwerte.yearWinterMW(jahr));
                    }
                }
                throw new IllegalStateException("Unexpected value: " + halbjahr);
            }
            case H: {
                switch (halbjahr) {
                    case sommer: {
                        return TimestampedValue.toOptional(this.tagesh\u00f6chstwerte.yearSummerHW(jahr));
                    }
                    case winter: {
                        return TimestampedValue.toOptional(this.tagesh\u00f6chstwerte.yearWinterHW(jahr));
                    }
                }
                throw new IllegalStateException("Unexpected value: " + halbjahr);
            }
        }
        throw new IllegalStateException("Unexpected value: " + art);
    }

    public OptionalMitMarkierung<? extends TimestampedValue> jahreswert(Year jahr, Art art) {
        switch (art) {
            case N: {
                return new OptionalMitMarkierung<Tagesmittelwert>(this.tagesmittelwerte.yearNW(jahr));
            }
            case M: {
                return new OptionalMitMarkierung<TimestampedValue>(this.tagesmittelwerte.yearMW(jahr));
            }
            case H: {
                return new OptionalMitMarkierung<Tagesh\u00f6chstwert>(this.tagesh\u00f6chstwerte.yearHW(jahr));
            }
        }
        throw new IllegalStateException("Unexpected value: " + art);
    }

    public mehrj\u00e4hrigeHauptwerte yearsRangeMainValues(int startYear, int endYear) {
        return new mehrj\u00e4hrigeHauptwerte(startYear, endYear, this.ausfalljahre);
    }

    public static enum Art {
        N,
        MN,
        H,
        MH,
        M;

    }

    public class mehrj\u00e4hrigeHauptwerte {
        private final int startYear;
        private final int endYear;
        private final Ausfalljahre ausfalljahre;
        private final MinFinder<Tagesmittelwert> winterMinFinder = new MinFinder();
        private final Meaner<TimestampedValue> winterMinMeaner = new Meaner();
        private final Meaner<TimestampedValue> winterMeaner = new Meaner();
        private final Meaner<TimestampedValue> winterMaxMeaner = new Meaner();
        private final MaxFinder<Tagesh\u00f6chstwert> winterMaxFinder = new MaxFinder();
        private final MinFinder<Tagesmittelwert> summerMinFinder = new MinFinder();
        private final Meaner<TimestampedValue> summerMinMeaner = new Meaner();
        private final Meaner<TimestampedValue> summerMeaner = new Meaner();
        private final Meaner<TimestampedValue> summerMaxMeaner = new Meaner();
        private final MaxFinder<Tagesh\u00f6chstwert> summerMaxFinder = new MaxFinder();
        private final MinFinder<Tagesmittelwert> yearsMinFinder = new MinFinder();
        private final Meaner<TimestampedValue> yearsMinMeaner = new Meaner();
        private final Meaner<TimestampedValue> yearsMeaner = new Meaner();
        private final Meaner<TimestampedValue> yearsMaxMeaner = new Meaner();
        private final MaxFinder<Tagesh\u00f6chstwert> yearsMaxFinder = new MaxFinder();
        private final MinFinder<Tagesmittelwert> calendarYearsMinFinder = new MinFinder();
        private final Meaner<TimestampedValue> calendarYearsMinMeaner = new Meaner();
        private final Meaner<TimestampedValue> calendarYearsMeaner = new Meaner();
        private final Meaner<TimestampedValue> calendarYearsMaxMeaner = new Meaner();
        private final MaxFinder<Tagesh\u00f6chstwert> calendarYearsMaxFinder = new MaxFinder();

        public mehrj\u00e4hrigeHauptwerte(int startYear, int endYear, Ausfalljahre ausfalljahre) {
            this.startYear = startYear;
            this.endYear = endYear;
            this.ausfalljahre = ausfalljahre;
            this.calculate();
        }

        private void calculate() {
            for (int year = this.startYear; year <= this.endYear; ++year) {
                Abflussjahr abflussjahr = new Abflussjahr(year);
                if (this.ausfalljahre.contain(abflussjahr)) continue;
                Tagesmittelwert winterNW = Hauptwerte.this.tagesmittelwerte.yearWinterNW(abflussjahr);
                this.winterMinFinder.add(winterNW);
                this.winterMinMeaner.add(winterNW);
                this.winterMeaner.add(Hauptwerte.this.tagesmittelwerte.yearWinterMW(abflussjahr));
                Tagesh\u00f6chstwert winterHW = Hauptwerte.this.tagesh\u00f6chstwerte.yearWinterHW(abflussjahr);
                this.winterMaxFinder.add(winterHW);
                this.winterMaxMeaner.add(winterHW);
                Tagesmittelwert summerNW = Hauptwerte.this.tagesmittelwerte.yearSummerNW(abflussjahr);
                this.summerMinFinder.add(summerNW);
                this.summerMinMeaner.add(summerNW);
                this.summerMeaner.add(Hauptwerte.this.tagesmittelwerte.yearSummerMW(abflussjahr));
                Tagesh\u00f6chstwert summerHW = Hauptwerte.this.tagesh\u00f6chstwerte.yearSummerHW(abflussjahr);
                this.summerMaxFinder.add(summerHW);
                this.summerMaxMeaner.add(summerHW);
                List<Tagesmittelwert> yearNW = Hauptwerte.this.tagesmittelwerte.yearNW(abflussjahr);
                this.yearsMinFinder.addAll(yearNW);
                if (yearNW.size() > 0) {
                    this.yearsMinMeaner.add(yearNW.get(0));
                }
                this.yearsMeaner.add(Hauptwerte.this.tagesmittelwerte.yearMW(abflussjahr));
                List<Tagesh\u00f6chstwert> yearHW = Hauptwerte.this.tagesh\u00f6chstwerte.yearHW(abflussjahr);
                this.yearsMaxFinder.addAll(yearHW);
                if (yearHW.size() > 0) {
                    this.yearsMaxMeaner.add(yearHW.get(0));
                }
                Kalenderjahr kalenderjahr = new Kalenderjahr(year);
                List<Tagesmittelwert> calendarYearNW = Hauptwerte.this.tagesmittelwerte.yearNW(kalenderjahr);
                this.calendarYearsMinFinder.addAll(calendarYearNW);
                if (calendarYearNW.size() > 0) {
                    this.calendarYearsMinMeaner.add(calendarYearNW.get(0));
                }
                this.calendarYearsMeaner.add(Hauptwerte.this.tagesmittelwerte.yearMW(kalenderjahr));
                List<Tagesh\u00f6chstwert> calendarYearHW = Hauptwerte.this.tagesh\u00f6chstwerte.yearHW(kalenderjahr);
                this.calendarYearsMaxFinder.addAll(calendarYearHW);
                if (calendarYearHW.size() <= 0) continue;
                this.calendarYearsMaxMeaner.add(calendarYearHW.get(0));
            }
        }

        public Optional<? extends TimestampedValue> abflusshalbjahrN(Abflusshalbjahr abflusshalbjahr) {
            switch (abflusshalbjahr) {
                case winter: {
                    return this.winterMinFinder.min();
                }
                case sommer: {
                    return this.summerMinFinder.min();
                }
            }
            throw abflusshalbjahr.MissingCaseInSwitch;
        }

        public Optional<? extends TimestampedValue> abflusshalbjahrH(Abflusshalbjahr abflusshalbjahr) {
            switch (abflusshalbjahr) {
                case winter: {
                    return this.winterH();
                }
                case sommer: {
                    return this.summerH();
                }
            }
            throw abflusshalbjahr.MissingCaseInSwitch;
        }

        public TimestampedValue abflusshalbjahrMN(Abflusshalbjahr abflusshalbjahr) {
            switch (abflusshalbjahr) {
                case winter: {
                    return this.winterMinMeaner.mean();
                }
                case sommer: {
                    return this.summerMinMeaner.mean();
                }
            }
            throw abflusshalbjahr.MissingCaseInSwitch;
        }

        public TimestampedValue abflusshalbjahrM(Abflusshalbjahr abflusshalbjahr) {
            switch (abflusshalbjahr) {
                case winter: {
                    return this.winterMeaner.mean();
                }
                case sommer: {
                    return this.summerMeaner.mean();
                }
            }
            throw abflusshalbjahr.MissingCaseInSwitch;
        }

        public TimestampedValue abflusshalbjahrMH(Abflusshalbjahr abflusshalbjahr) {
            switch (abflusshalbjahr) {
                case winter: {
                    return this.winterMaxMeaner.mean();
                }
                case sommer: {
                    return this.summerMaxMeaner.mean();
                }
            }
            throw abflusshalbjahr.MissingCaseInSwitch;
        }

        public List<Tagesmittelwert> NW() {
            return this.yearsMinFinder.minima();
        }

        public TimestampedValue MNW() {
            return this.yearsMinMeaner.mean();
        }

        public TimestampedValue MW() {
            return this.yearsMeaner.mean();
        }

        public TimestampedValue MHW() {
            return this.yearsMaxMeaner.mean();
        }

        public Optional<? extends TimestampedValue> winterH() {
            return this.winterMaxFinder.max();
        }

        public Optional<? extends TimestampedValue> summerH() {
            return this.summerMaxFinder.max();
        }

        public List<Tagesh\u00f6chstwert> HW() {
            return this.yearsMaxFinder.maxima();
        }

        public List<Tagesmittelwert> calendarYearsNW() {
            return this.calendarYearsMinFinder.minima();
        }

        public TimestampedValue calendarYearsMNW() {
            return this.calendarYearsMinMeaner.mean();
        }

        public TimestampedValue calendarYearsMW() {
            return this.calendarYearsMeaner.mean();
        }

        public TimestampedValue calendarYearsMHW() {
            return this.calendarYearsMaxMeaner.mean();
        }

        public List<Tagesh\u00f6chstwert> calendarYearsHW() {
            return this.calendarYearsMaxFinder.maxima();
        }

        public OptionalMitMarkierung<? extends TimestampedValue> jahreswert(Art art) {
            switch (art) {
                case H: {
                    return new OptionalMitMarkierung<Tagesh\u00f6chstwert>(this.HW());
                }
                case MH: {
                    return new OptionalMitMarkierung<TimestampedValue>(this.MHW());
                }
                case M: {
                    return new OptionalMitMarkierung<TimestampedValue>(this.MW());
                }
                case MN: {
                    return new OptionalMitMarkierung<TimestampedValue>(this.MNW());
                }
                case N: {
                    return new OptionalMitMarkierung<Tagesmittelwert>(this.NW());
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + art);
        }

        public OptionalMitMarkierung<? extends TimestampedValue> kalenderjahr(Art art) {
            switch (art) {
                case H: {
                    return new OptionalMitMarkierung<Tagesh\u00f6chstwert>(this.calendarYearsHW());
                }
                case MH: {
                    return new OptionalMitMarkierung<TimestampedValue>(this.calendarYearsMHW());
                }
                case M: {
                    return new OptionalMitMarkierung<TimestampedValue>(this.calendarYearsMW());
                }
                case MN: {
                    return new OptionalMitMarkierung<TimestampedValue>(this.calendarYearsMNW());
                }
                case N: {
                    return new OptionalMitMarkierung<Tagesmittelwert>(this.calendarYearsNW());
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + art);
        }

        public Optional<? extends TimestampedValue> abflusshalbjahr(Art art, Abflusshalbjahr abflusshalbjahr) {
            switch (art) {
                case H: {
                    return this.abflusshalbjahrH(abflusshalbjahr);
                }
                case MH: {
                    return this.abflusshalbjahrMH(abflusshalbjahr).asOptional();
                }
                case M: {
                    return this.abflusshalbjahrM(abflusshalbjahr).asOptional();
                }
                case MN: {
                    return this.abflusshalbjahrMN(abflusshalbjahr).asOptional();
                }
                case N: {
                    return this.abflusshalbjahrN(abflusshalbjahr);
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + art);
        }
    }
}

