/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.SortedMap;
import java.util.TreeMap;
import org.joda.time.DateTime;

public class HandUndSystemWerte {
    private final SortedMap<DateTime, ValuePair> values = new TreeMap<DateTime, ValuePair>();

    public void addHandValue(DateTime timestamp, double value) {
        if (!this.values.containsKey(timestamp)) {
            this.values.put(timestamp, new ValuePair(value, null));
            return;
        }
        if (((ValuePair)this.values.get(timestamp)).handValue() == null) {
            this.values.put(timestamp, ((ValuePair)this.values.get(timestamp)).withHandValue(value));
        }
    }

    public void addSystemValue(DateTime timestamp, double value) {
        if (!this.values.containsKey(timestamp)) {
            this.values.put(timestamp, new ValuePair(null, value));
            return;
        }
        if (((ValuePair)this.values.get(timestamp)).systemValue() == null) {
            this.values.put(timestamp, ((ValuePair)this.values.get(timestamp)).withSystemValue(value));
        }
    }

    public SortedMap<DateTime, ValuePair> values() {
        return this.values;
    }

    public boolean hasValuesFor(DateTime timestamp) {
        return this.values.containsKey(timestamp);
    }

    public ValuePair valuesFor(DateTime timestamp) {
        return (ValuePair)this.values.get(timestamp);
    }

    public static class ValuePair {
        private final Double handValue;
        private final Double systemValue;

        public ValuePair() {
            this(null, null);
        }

        private ValuePair(Double handValue, Double systemValue) {
            this.handValue = handValue;
            this.systemValue = systemValue;
        }

        public Double handValue() {
            return this.handValue;
        }

        public Double systemValue() {
            return this.systemValue;
        }

        public ValuePair withSystemValue(Double newSystemValue) {
            return new ValuePair(this.handValue(), newSystemValue);
        }

        public ValuePair withHandValue(Double newHandValue) {
            return new ValuePair(newHandValue, this.systemValue());
        }
    }
}

