/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Day;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class Formel {
    private final List<Summand> summands;

    private Formel(List<Summand> summands) {
        this.summands = summands;
    }

    public static Formel parse(String f2) {
        ArrayList<Summand> summands = new ArrayList<Summand>();
        Pattern pattern = Pattern.compile("([+-])?(\\d+)");
        Matcher matcher = pattern.matcher(f2);
        while (matcher.find()) {
            summands.add(new Summand("-".equals(matcher.group(1)) ? -1.0 : 1.0, Long.parseLong(matcher.group(2))));
        }
        return new Formel(summands);
    }

    public List<Long> messstellenNummern() {
        return this.summands.stream().map(Summand::station).collect(Collectors.toList());
    }

    public List<? extends TimestampedValue> calculate(Map<Long, List<? extends TimestampedValue>> values, double factor) {
        int length = values.get(this.summands.get(0).station()).size();
        for (Summand s2 : this.summands) {
            if (values.get(s2.station()).size() >= length) continue;
            length = values.get(s2.station()).size();
        }
        ArrayList<TimestampedValue> result = new ArrayList<TimestampedValue>();
        for (int i2 = 0; i2 < length; ++i2) {
            double sum = 0.0;
            boolean isGap = false;
            for (Summand s3 : this.summands) {
                if (values.get(s3.station()).get(i2).istL\u00fccke()) {
                    isGap = true;
                    continue;
                }
                sum += values.get(s3.station()).get(i2).wert() * s3.factor();
            }
            if (isGap) {
                result.add(new TimestampedValue(values.get(this.summands.get(0).station()).get(i2).timestamp()));
                continue;
            }
            result.add(new TimestampedValue(values.get(this.summands.get(0).station()).get(i2).timestamp(), factor * sum));
        }
        return result;
    }

    public Tagesmittelwerte calculateDayMeans(Interval interval, Map<Long, Tagesmittelwerte> values, double factor) {
        Tagesmittelwerte result = new Tagesmittelwerte();
        DateTime day = interval.getStart();
        while (day.isBefore(interval.getEnd())) {
            double sum = 0.0;
            for (Summand s2 : this.summands) {
                sum += values.get(s2.station()).ofDay(new Day(day)).get().wert() * s2.factor();
            }
            result.add(new Tagesmittelwert(day, factor * sum));
            day = day.plusDays(1);
        }
        return result;
    }

    private static class Summand {
        private final double factor;
        private final long station;

        private Summand(double factor, long station) {
            this.factor = factor;
            this.station = station;
        }

        public double factor() {
            return this.factor;
        }

        public long station() {
            return this.station;
        }
    }
}

