/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.Optional;
import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.units.Abflussspende;
import luwa.marlin.ship_library.model.units.Units;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import org.joda.time.DateTime;

public class Extremwert {
    public static final int topN = 10;
    private final TimestampedValue wert;
    private final AbflussOderWasserstand QoderW;
    private final Optional<? extends Quantity<Length>> wasserstand;
    private final Optional<? extends Quantity<Abflussspende>> spende;

    public Extremwert(TimestampedValue wert) {
        this.QoderW = AbflussOderWasserstand.W;
        this.wert = wert;
        this.wasserstand = Optional.empty();
        this.spende = Optional.empty();
    }

    public Extremwert(TimestampedValue wert, Optional<? extends Quantity<Abflussspende>> spende, Optional<? extends Quantity<Length>> wasserstand) {
        this.QoderW = AbflussOderWasserstand.Q;
        this.wert = wert;
        this.wasserstand = wasserstand;
        this.spende = spende;
    }

    public Optional<Double> wert() {
        return this.wert.vielleichtWert();
    }

    public DateTime datum() {
        return this.wert.timestamp();
    }

    public AbflussOderWasserstand QoderW() {
        return this.QoderW;
    }

    public Optional<? extends Quantity<Length>> wasserstand() {
        if (this.QoderW.equals((Object)AbflussOderWasserstand.W)) {
            throw new IllegalStateException("Extremwert auf W-Seite hat keine zus\u00e4tzliche Angabe des Wasserstandes.");
        }
        return this.wasserstand;
    }

    public Optional<? extends Quantity<Abflussspende>> spende() {
        if (this.QoderW.equals((Object)AbflussOderWasserstand.W)) {
            throw new IllegalStateException("Extremwert auf W-Seite hat keine Angabe der Spende.");
        }
        return this.spende;
    }

    public Optional<Double> SpendeInLiterProQuadratkilometer() {
        if (this.spende().isEmpty()) {
            return Optional.empty();
        }
        if (!this.spende().get().getUnit().equals(Units.LITRE_PER_SECOND_TIMES_SQUARE_KILOMETRE)) {
            throw new IllegalStateException("wrong unit for Spende: " + this.spende().get().getUnit());
        }
        return Optional.of(this.spende().get().getValue().doubleValue());
    }

    public Optional<Double> WasserstandInCm() {
        if (this.wasserstand().isPresent()) {
            Quantity<Length> wasserstand = this.wasserstand().get();
            if (!wasserstand.getUnit().equals(MetricPrefix.CENTI(tech.units.indriya.unit.Units.METRE))) {
                throw new IllegalStateException("wrong unit for Wasserstand: " + wasserstand.getUnit());
            }
            return Optional.of(wasserstand.getValue().doubleValue());
        }
        return Optional.empty();
    }
}

