/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import luwa.marlin.ship_library.model.Dauertabelle;
import luwa.marlin.ship_library.model.year.Year;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Dauerzahlen {
    NachDGJ{

        @Override
        public List<Integer> dauerzahlenInTagen(Year year) {
            if (year.istSchaltjahr()) {
                return dauerzahlenSchaltjahrInTagen;
            }
            return dauerzahlenGemeinjahrInTagen;
        }

        @Override
        public List<Integer> dauerzahlenInTagenImGemeinjahr() {
            return dauerzahlenGemeinjahrInTagen;
        }
    }
    ,
    AlleTage{

        @Override
        public List<Integer> dauerzahlenInTagen(Year year) {
            return year.istSchaltjahr() ? Dauertabelle.alleUnterschreitungsdauernInTagenImSchaltjahr() : Dauertabelle.alleUnterschreitungsdauernInTagenImGemeinjahr();
        }

        @Override
        public List<Integer> dauerzahlenInTagenImGemeinjahr() {
            return Dauertabelle.alleUnterschreitungsdauernInTagenImGemeinjahr();
        }
    };

    private static final List<Integer> dauerzahlenGemeinjahrInTagen;
    private static final List<Integer> dauerzahlenSchaltjahrInTagen;

    public abstract List<Integer> dauerzahlenInTagen(Year var1);

    public abstract List<Integer> dauerzahlenInTagenImGemeinjahr();

    private static List<Integer> makeLeapYearDays() {
        ArrayList<Integer> tage = new ArrayList<Integer>(Dauerzahlen.makeDays());
        tage.add(0, 365);
        return tage;
    }

    private static List<Integer> makeDays() {
        List<Integer> result = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 40, 50, 60, 70, 90, 100, 110, 120, 130, 150, 182, 200, 210, 240, 270, 300, 320, 330, 340, 350, 356, 357, 358, 359, 360, 361, 362, 363, 364);
        result.sort(Collections.reverseOrder());
        return result;
    }

    static {
        dauerzahlenGemeinjahrInTagen = Dauerzahlen.makeDays();
        dauerzahlenSchaltjahrInTagen = Dauerzahlen.makeLeapYearDays();
    }
}

