/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Dauertabelle;
import luwa.marlin.ship_library.model.Extremwerte;
import luwa.marlin.ship_library.model.Hauptwerte;
import luwa.marlin.ship_library.model.JahrbuchseitenConfiguration;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.Pegelnullpunktwechsel;
import luwa.marlin.ship_library.model.Scheitelwerte;
import luwa.marlin.ship_library.model.Tagesh\u00f6chstwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.Tageswerte;
import luwa.marlin.ship_library.model.VergleichMitMillimeterGenauigkeit;
import luwa.marlin.ship_library.model.ZeitbereicheMitErg\u00e4nztenWerten;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.ErweitertesJahr;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.DatenRepositoryMitVerkettung;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DatenF\u00fcrJahrbuchseite {
    private final Comparator<Tagesmittelwert> vergleichVonTagesmittelwerten;
    private Messstelle messstelle;
    private Ausfalljahre ausfalljahre;
    private final DateTime anfangDerAufzeichnungen;
    private final JahrbuchseitenConfiguration config;
    private final DatenRepository data;
    private Optional<Benutzer> benutzer;
    private Optional<Scheitelwerte> scheitelwerteW;
    private Optional<Tagesmittelwerte> tagesmittelwerteW;
    private Optional<Tagesh\u00f6chstwerte> tagesh\u00f6chstwerteW;
    private boolean abflussspendeBerechnen;
    private Pegelnullpunktwechsel pegelnullpunktwechsel;
    private Tageswerte tageswerte;
    private Hauptwerte hauptwerte;
    private Extremwerte extremwerte;
    private Dauertabelle dauertabelle;
    private String allgemeineBemerkung;
    private NHNTransformationOfTimestampedValues maybeNHNTransform;

    public DatenF\u00fcrJahrbuchseite(JahrbuchseitenConfiguration config, DatenRepository datenRepository) throws Exception {
        this.config = config;
        if (datenRepository.getClass() == DatenRepositoryMitVerkettung.class) {
            throw new IllegalArgumentException("datenRepository darf nicht vom Typ DatenRepositoryMitVerkettung sein!");
        }
        this.data = config.abflussOderWasserstand() == AbflussOderWasserstand.Q ? new DatenRepositoryMitVerkettung(datenRepository) : datenRepository;
        this.vergleichVonTagesmittelwerten = new VergleichMitMillimeterGenauigkeit<Tagesmittelwert>(config.wasserstandBezugsh\u00f6he(), config.abflussOderWasserstand());
        this.anfangDerAufzeichnungen = this.data.anfangDerAufzeichnungen(config.messstellenNummer(), config.parameter());
        this.load();
    }

    private void load() throws Exception {
        this.loadDataDependingOnConfig();
        ZeitbereicheMitErg\u00e4nztenWerten editedRanges = this.loadEditedRanges();
        Tagesmittelwerte tagesmittelwerteMitAusfalljahren = this.loadTagesmittelwerte(this.zeitreiheUndJahr());
        Tagesmittelwerte tagesmittelwerteWithoutOutageForEndYear = this.loadTagesmittelwerte(this.erweitertesJahr());
        Tagesmittelwerte alleTagesmittelwerteOhneAusfalljahre = this.loadTagesmittelwerte(this.anfangAufzeichnungenBisEnde());
        Tagesh\u00f6chstwerte tagesh\u00f6chstwerteMitAusfalljahren = this.loadTagesh\u00f6chstwerte();
        Scheitelwerte scheitelwerteOhneAusfalljahre = this.loadScheitelwerte();
        this.ladeZus\u00e4tzlichWwerteFallsN\u00f6tig(this.zeitreiheUndJahr(), this.anfangAufzeichnungenBisEnde());
        this.tageswerte = new Tageswerte(tagesmittelwerteWithoutOutageForEndYear, editedRanges);
        this.hauptwerte = new Hauptwerte(tagesmittelwerteMitAusfalljahren, tagesh\u00f6chstwerteMitAusfalljahren, scheitelwerteOhneAusfalljahre, alleTagesmittelwerteOhneAusfalljahre, this.ausfalljahre);
        this.extremwerte = new Extremwerte(alleTagesmittelwerteOhneAusfalljahre, scheitelwerteOhneAusfalljahre, this.tagesmittelwerteW, this.scheitelwerteW);
        this.dauertabelle = new Dauertabelle(tagesmittelwerteMitAusfalljahren, this.ausfalljahre, this.config.wasserstandBezugsh\u00f6he());
        this.allgemeineBemerkung = this.data.allgemeineBemerkungDGJ();
    }

    private ZeitbereicheMitErg\u00e4nztenWerten loadEditedRanges() throws Exception {
        return this.data.bearbeiteteZeitbereiche(this.config.messstellenNummer(), this.config.parameter(), this.zeitbereichF\u00fcrErg\u00e4nzungen());
    }

    private void loadDataDependingOnConfig() throws Exception {
        this.messstelle = this.data.messstelle(this.config.messstellenNummer());
        this.benutzer = this.benutzer(this.config, this.data);
        this.ausfalljahre = this.data.ausfalljahre(this.config.messstellenNummer(), this.config.parameter(), this.zeitreiheUndJahr());
        List<Pegelnullpunkt> pegelnullpunkte = this.data.pegelnullpunkte(this.config.messstellenNummer());
        this.pegelnullpunktwechsel = new Pegelnullpunktwechsel(pegelnullpunkte, TimestampedValue.toZonedInterval(this.anfangAufzeichnungenBisErstellungsdatum()));
        this.maybeNHNTransform = new NHNTransformationOfTimestampedValues(pegelnullpunkte, this.config.wasserstandBezugsh\u00f6he());
    }

    private Scheitelwerte loadScheitelwerte() throws Exception {
        return this.data.scheitelwerte(this.config.messstellenNummer(), this.config.parameter(), this.anfangAufzeichnungenBisEnde(), Ausfalljahre.keine, 1.0, this.maybeNHNTransform);
    }

    private Tagesh\u00f6chstwerte loadTagesh\u00f6chstwerte() throws Exception {
        return this.data.tagesh\u00f6chstwerte(this.config.messstellenNummer(), this.config.parameter(), this.zeitreiheUndJahr(), Ausfalljahre.keine, 1.0, this.maybeNHNTransform);
    }

    private Tagesmittelwerte loadTagesmittelwerte(Interval interval) throws Exception {
        return this.data.tagesmittelwerte(this.config.messstellenNummer(), this.config.parameter(), interval, Ausfalljahre.keine, 1.0, this.maybeNHNTransform, this.vergleichVonTagesmittelwerten);
    }

    private Interval coveringInterval(Interval I1, Interval I2) {
        BiFunction<ReadableInstant, ReadableInstant, ReadableInstant> min = (t1, t2) -> t1.isBefore((ReadableInstant)t2) ? t1 : t2;
        BiFunction<ReadableInstant, ReadableInstant, ReadableInstant> max = (t1, t2) -> t1.isAfter((ReadableInstant)t2) ? t1 : t2;
        return new Interval(min.apply(I1.getStart(), I2.getStart()), max.apply(I1.getEnd(), I2.getEnd()));
    }

    private Interval anfangAufzeichnungenBisErstellungsdatum() {
        return this.anfangAufzeichnungenBisEndeJahr(this.anfangDerAufzeichnungen, this.config.erstellungsdatum().getYear());
    }

    private Interval zeitbereichF\u00fcrErg\u00e4nzungen() {
        return this.zeitbereichF\u00fcrErg\u00e4nzungen(this.config.jahr());
    }

    private Interval anfangAufzeichnungenBisEnde() {
        return this.anfangAufzeichnungenBisEndeJahr(this.anfangDerAufzeichnungen, Integer.max(this.config.jahr(), this.config.endjahrZeitreihe()));
    }

    private Interval zeitreiheUndJahr() {
        return this.anfangZeitreiheBisEndeJahr(Integer.min(this.config.jahr(), this.config.anfangsjahrZeitreihe()), Integer.max(this.config.jahr(), this.config.endjahrZeitreihe()));
    }

    private Interval erweitertesJahr() {
        return new ErweitertesJahr(this.config.jahr()).interval();
    }

    private void ladeZus\u00e4tzlichWwerteFallsN\u00f6tig(Interval zeitreiheUndJahr, Interval anfangAufzeichnungenBisEnde) throws Exception {
        this.scheitelwerteW = this.ladescheitelwerteW(this.config, this.data, anfangAufzeichnungenBisEnde);
        this.tagesmittelwerteW = this.ladeTagesmittelwerteW(this.config, this.data, anfangAufzeichnungenBisEnde);
        this.tagesh\u00f6chstwerteW = this.ladeTagesh\u00f6chstwerteW(this.config, this.data, zeitreiheUndJahr);
        this.abflussspendeBerechnen = this.ladeAbflussspendeBerechnen(this.config, this.data);
    }

    private boolean ladeAbflussspendeBerechnen(JahrbuchseitenConfiguration config, DatenRepository data) throws Exception {
        if (config.abflussOderWasserstand() == AbflussOderWasserstand.Q) {
            return data.abflussspendeRechnen(config.messstellenNummer());
        }
        return false;
    }

    private Optional<Tagesh\u00f6chstwerte> ladeTagesh\u00f6chstwerteW(JahrbuchseitenConfiguration config, DatenRepository data, Interval zeitreiheUndJahr) throws Exception {
        if (config.abflussOderWasserstand() == AbflussOderWasserstand.Q) {
            return Optional.of(data.tagesh\u00f6chstwerte(config.messstellenNummer(), Parameter.w, zeitreiheUndJahr, new Ausfalljahre(), 1.0, NHNTransformationOfTimestampedValues.doNothing()));
        }
        return Optional.empty();
    }

    private Optional<Tagesmittelwerte> ladeTagesmittelwerteW(JahrbuchseitenConfiguration config, DatenRepository data, Interval anfangAufzeichnungenBisEnde) throws Exception {
        if (config.abflussOderWasserstand() == AbflussOderWasserstand.Q) {
            return Optional.of(data.tagesmittelwerte(config.messstellenNummer(), Parameter.w, anfangAufzeichnungenBisEnde, new Ausfalljahre(), 1.0));
        }
        return Optional.empty();
    }

    private Optional<Scheitelwerte> ladescheitelwerteW(JahrbuchseitenConfiguration config, DatenRepository data, Interval anfangAufzeichnungenBisEnde) throws Exception {
        if (config.abflussOderWasserstand() == AbflussOderWasserstand.Q) {
            return Optional.of(data.scheitelwerte(config.messstellenNummer(), Parameter.w, anfangAufzeichnungenBisEnde, new Ausfalljahre(), 1.0, NHNTransformationOfTimestampedValues.doNothing()));
        }
        return Optional.empty();
    }

    public Optional<Benutzer> benutzer(JahrbuchseitenConfiguration config, DatenRepository data) throws Exception {
        Optional<Long> benutzerId = config.userId();
        if (benutzerId.isPresent()) {
            return Optional.of(data.benutzer(benutzerId.get()));
        }
        return Optional.empty();
    }

    private Interval zeitbereichF\u00fcrErg\u00e4nzungen(int jahr) {
        return new Interval((ReadableInstant)new ErweitertesJahr(jahr).interval().getStart(), (ReadableInstant)new ErweitertesJahr(jahr).interval().getEnd());
    }

    private Interval anfangAufzeichnungenBisEndeJahr(DateTime anfangDerAufzeichnungen, int jahr) {
        DateTime endZeitpunkt = new Kalenderjahr(jahr).interval().getEnd();
        if (endZeitpunkt.isBefore(anfangDerAufzeichnungen)) {
            endZeitpunkt = anfangDerAufzeichnungen;
        }
        return new Interval((ReadableInstant)anfangDerAufzeichnungen, (ReadableInstant)endZeitpunkt);
    }

    private Interval anfangZeitreiheBisEndeJahr(int anfangJahresreihe, int jahr) {
        return new Interval((ReadableInstant)new Abflussjahr(anfangJahresreihe).interval().getStart(), (ReadableInstant)new Kalenderjahr(jahr).interval().getEnd());
    }

    public Dauertabelle dauertabelle() {
        return this.dauertabelle;
    }

    public Extremwerte extremwerte() {
        return this.extremwerte;
    }

    public Messstelle messstelle() {
        return this.messstelle;
    }

    public Ausfalljahre ausfalljahre() {
        return this.ausfalljahre;
    }

    public DateTime anfangDerAufzeichnungen() {
        return this.anfangDerAufzeichnungen;
    }

    public Optional<Benutzer> benutzer() {
        return this.benutzer;
    }

    public Optional<Scheitelwerte> scheitelwerteW() {
        return this.scheitelwerteW;
    }

    public Optional<Tagesmittelwerte> tagesmittelwerteW() {
        return this.tagesmittelwerteW;
    }

    public Optional<Tagesh\u00f6chstwerte> tagesh\u00f6chstwerteW() {
        return this.tagesh\u00f6chstwerteW;
    }

    public boolean abflussspendeSollBerechnetWerden() {
        return this.abflussspendeBerechnen;
    }

    public Pegelnullpunktwechsel pegelnullpunktwechsel() {
        return this.pegelnullpunktwechsel;
    }

    public Tageswerte tageswerte() {
        return this.tageswerte;
    }

    public Hauptwerte hauptwerte() {
        return this.hauptwerte;
    }

    public String allgemeineBemerkung() {
        return this.allgemeineBemerkung;
    }
}

