/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.time.ZonedDateTime;
import java.util.Optional;
import javax.measure.Quantity;
import javax.measure.quantity.Area;
import javax.measure.quantity.Length;
import javax.measure.quantity.Speed;
import luwa.marlin.ship_library.model.units.Abfluss;
import luwa.marlin.ship_library.model.units.Abflussspende;
import luwa.marlin.ship_library.model.units.ProfilwertNachManningStrickler;
import tech.units.indriya.unit.Units;

public class AbflussmessungErgebnisse {
    private final Quantity<Abfluss> abfluss;
    private final Quantity<Area> durchflussquerschnitt;
    private final Quantity<Speed> mittlereFlie\u00dfgeschwindigkeit;
    private final Quantity<Speed> maximaleOberfl\u00e4chengeschwindigkeit;
    private final Quantity<Speed> mittlereOberfl\u00e4chengeschwindigkeit;
    private final Quantity<Length> wasserspiegelbreite;
    private final Optional<Quantity<Abflussspende>> abflussspende;
    private final Quantity<Length> mittlererWasserstand;
    private final Quantity<Length> minimalerWasserstand;
    private final Quantity<Length> maximalerWasserstand;
    private final Quantity<Length> benetzterUmfang;
    private final Quantity<Length> hydraulischerRadius;
    private final Quantity<Length> maximaleTiefe;
    private final Quantity<ProfilwertNachManningStrickler> profilwertNachManningStrickler;
    private final String berechnungsverfahren;
    private final String methodeF\u00fcrEinpunktmessungen;
    private final String methodeF\u00fcrZweipunktmessungen;
    private final boolean importiert;
    private final ZonedDateTime berechnungszeitpunkt;
    private final Optional<Double> anteilFl\u00e4cheErfasst;
    private final Optional<Double> anteil\u00dcberSohleNichtErfasst;

    public AbflussmessungErgebnisse(Quantity<Abfluss> abfluss, Quantity<Area> durchflussquerschnitt, Quantity<Speed> mittlereFlie\u00dfgeschwindigkeit, Quantity<Speed> maximaleOberfl\u00e4chengeschwindigkeit, Quantity<Speed> mittlereOberfl\u00e4chengeschwindigkeit, Quantity<Length> wasserspiegelbreite, Quantity<Length> mittlererWasserstand, Quantity<Length> minimalerWasserstand, Quantity<Length> maximalerWasserstand, Optional<Quantity<Abflussspende>> abflussspende, Quantity<Length> benetzterUmfang, Quantity<Length> hydraulischerRadius, Quantity<Length> maximaleTiefe, Quantity<ProfilwertNachManningStrickler> profilwertNachManningStrickler, String berechnungsverfahren, String methodeF\u00fcrEinpunktmessungen, String methodeF\u00fcrZweipunktmessungen, boolean importiert, ZonedDateTime berechnungszeitpunkt, Optional<Double> anteilFl\u00e4cheErfasst, Optional<Double> anteil\u00dcberSohleNichtErfasst) {
        this.abfluss = abfluss;
        this.durchflussquerschnitt = durchflussquerschnitt;
        this.mittlereFlie\u00dfgeschwindigkeit = mittlereFlie\u00dfgeschwindigkeit;
        this.maximaleOberfl\u00e4chengeschwindigkeit = maximaleOberfl\u00e4chengeschwindigkeit;
        this.mittlereOberfl\u00e4chengeschwindigkeit = mittlereOberfl\u00e4chengeschwindigkeit;
        this.wasserspiegelbreite = wasserspiegelbreite;
        this.mittlererWasserstand = mittlererWasserstand;
        this.minimalerWasserstand = minimalerWasserstand;
        this.maximalerWasserstand = maximalerWasserstand;
        this.abflussspende = abflussspende;
        this.benetzterUmfang = benetzterUmfang;
        this.hydraulischerRadius = hydraulischerRadius;
        this.maximaleTiefe = maximaleTiefe;
        this.profilwertNachManningStrickler = profilwertNachManningStrickler;
        this.berechnungsverfahren = berechnungsverfahren;
        this.methodeF\u00fcrEinpunktmessungen = methodeF\u00fcrEinpunktmessungen;
        this.methodeF\u00fcrZweipunktmessungen = methodeF\u00fcrZweipunktmessungen;
        this.importiert = importiert;
        this.berechnungszeitpunkt = berechnungszeitpunkt;
        this.anteilFl\u00e4cheErfasst = anteilFl\u00e4cheErfasst;
        this.anteil\u00dcberSohleNichtErfasst = anteil\u00dcberSohleNichtErfasst;
    }

    public ZonedDateTime berechnungszeitpunkt() {
        return this.berechnungszeitpunkt;
    }

    public Quantity<Area> durchflussquerschnitt() {
        return this.durchflussquerschnitt;
    }

    public Quantity<Abfluss> abfluss() {
        return this.abfluss;
    }

    public Quantity<Length> wasserspiegelbreite() {
        return this.wasserspiegelbreite;
    }

    public Optional<Quantity<Length>> mittlereGerinnetiefe() {
        if (0.0 == this.wasserspiegelbreite().getValue().doubleValue()) {
            return Optional.empty();
        }
        return Optional.of(this.durchflussquerschnitt().divide(this.wasserspiegelbreite()).asType(Length.class));
    }

    public Quantity<Speed> mittlereFlie\u00dfgeschwindigkeit() {
        return this.mittlereFlie\u00dfgeschwindigkeit;
    }

    public Quantity<Speed> maximaleOberfl\u00e4chengeschwindigkeit() {
        return this.maximaleOberfl\u00e4chengeschwindigkeit;
    }

    public Quantity<Speed> mittlereOberfl\u00e4chengeschwindigkeit() {
        return this.mittlereOberfl\u00e4chengeschwindigkeit;
    }

    public double verh\u00e4ltnisMittlereFlie\u00dfgeschwindigkeitZuMittlereOberfl\u00e4chengeschwindigkeit() {
        return this.mittlereFlie\u00dfgeschwindigkeit().to(Units.METRE_PER_SECOND).getValue().doubleValue() / this.mittlereOberfl\u00e4chengeschwindigkeit().to(Units.METRE_PER_SECOND).getValue().doubleValue();
    }

    public Quantity<Length> mittlererWasserstand() {
        return this.mittlererWasserstand;
    }

    public Quantity<Length> minimalerWasserstand() {
        return this.minimalerWasserstand;
    }

    public Quantity<Length> maximalerWasserstand() {
        return this.maximalerWasserstand;
    }

    public Optional<Quantity<Abflussspende>> abflussspende() {
        return this.abflussspende;
    }

    public Quantity<Length> benetzterUmfang() {
        return this.benetzterUmfang;
    }

    public Quantity<Length> hydraulischerRadius() {
        return this.hydraulischerRadius;
    }

    public Quantity<Length> maximaleTiefe() {
        return this.maximaleTiefe;
    }

    public Quantity<ProfilwertNachManningStrickler> profilwertNachManningStrickler() {
        return this.profilwertNachManningStrickler;
    }

    public String berechnungsverfahren() {
        return this.berechnungsverfahren;
    }

    public String methodeF\u00fcrEinpunktmessungen() {
        return this.methodeF\u00fcrEinpunktmessungen;
    }

    public String methodeF\u00fcrZweipunktmessungen() {
        return this.methodeF\u00fcrZweipunktmessungen;
    }

    public boolean importiert() {
        return this.importiert;
    }

    public Optional<Double> anteilFl\u00e4cheErfasst() {
        return this.anteilFl\u00e4cheErfasst;
    }

    public Optional<Double> anteil\u00dcberSohleNichtErfasst() {
        return this.anteil\u00dcberSohleNichtErfasst;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" {\n\tabfluss: ");
        builder.append(this.abfluss);
        builder.append("\n\tdurchflussquerschnitt: ");
        builder.append(this.durchflussquerschnitt);
        builder.append("\n\tmittlereFlie\u00dfgeschwindigkeit: ");
        builder.append(this.mittlereFlie\u00dfgeschwindigkeit);
        builder.append("\n\tmaximaleOberfl\u00e4chengeschwindigkeit: ");
        builder.append(this.maximaleOberfl\u00e4chengeschwindigkeit);
        builder.append("\n\tmittlereOberfl\u00e4chengeschwindigkeit: ");
        builder.append(this.mittlereOberfl\u00e4chengeschwindigkeit);
        builder.append("\n\twasserspiegelbreite: ");
        builder.append(this.wasserspiegelbreite);
        builder.append("\n\tabflussspende: ");
        builder.append(this.abflussspende);
        builder.append("\n\tmittlererWasserstand: ");
        builder.append(this.mittlererWasserstand);
        builder.append("\n\tminimalerWasserstand: ");
        builder.append(this.minimalerWasserstand);
        builder.append("\n\tmaximalerWasserstand: ");
        builder.append(this.maximalerWasserstand);
        builder.append("\n\tbenetzterUmfang: ");
        builder.append(this.benetzterUmfang);
        builder.append("\n\thydraulischerRadius: ");
        builder.append(this.hydraulischerRadius);
        builder.append("\n\tmaximaleTiefe: ");
        builder.append(this.maximaleTiefe);
        builder.append("\n\tprofilwertNachManningStrickler: ");
        builder.append(this.profilwertNachManningStrickler);
        builder.append("\n\tberechnungsverfahren: ");
        builder.append(this.berechnungsverfahren);
        builder.append("\n\tmethodeF\u00fcrEinpunktmessungen: ");
        builder.append(this.methodeF\u00fcrEinpunktmessungen);
        builder.append("\n\tmethodeF\u00fcrZweipunktmessungen: ");
        builder.append(this.methodeF\u00fcrZweipunktmessungen);
        builder.append("\n\tanteilFl\u00e4cheErfasst: ");
        builder.append(this.anteilFl\u00e4cheErfasst);
        builder.append("\n\tanteil\u00dcberSohleNichtErfasst: ");
        builder.append(this.anteil\u00dcberSohleNichtErfasst);
        builder.append("\n\timportiert: ");
        builder.append(this.importiert);
        builder.append("\n\tberechnungszeitpunkt: ");
        builder.append(this.berechnungszeitpunkt);
        builder.append("\n}");
        return builder.toString();
    }
}

