/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.\u00dcbersichtsRepository;
import luwa.marlin.ship_library.view.html.uebersicht.PegelMitN\u00e4chsterPegelschau;
import luwa.marlin.ship_library.view.html.uebersicht.PegelMitUng\u00fcltigerWQBeziehung;
import luwa.marlin.ship_library.view.html.uebersicht.ProjektHWGKAbgleich;
import luwa.marlin.ship_library.view.html.uebersicht.Sonstige\u00dcbersicht;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;

public class \u00dcbersichtHandler
extends OutputHandler {
    private static final String paramTyp = "typ";

    public \u00dcbersichtHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return List.of(paramTyp);
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        String typString = params.mandatoryString(paramTyp);
        Optional<\u00dcbersichtsTyp> typ = \u00dcbersichtsTyp.ausKey(typString);
        String authToken = params.optionalString("auth_token").orElse("");
        return typ.map(it -> it.htmlView(datenRepository.\u00fcbersicht(), authToken)).orElseThrow(() -> new IllegalArgumentException("Unbekannter \u00dcbersichts-Typ: " + typString));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum \u00dcbersichtsTyp {
        hwgkAbgleich("hwgkAbgleich"){

            @Override
            public OutputView htmlView(\u00dcbersichtsRepository repository, String authToken) {
                return new ProjektHWGKAbgleich(repository.projektHWGKAbgleich());
            }
        }
        ,
        ungueltigeWQBeziehung("ungueltigeWQBeziehung"){

            @Override
            public OutputView htmlView(\u00dcbersichtsRepository repository, String authToken) {
                return new PegelMitUng\u00fcltigerWQBeziehung(repository.pegelMitUng\u00fcltigerWQBeziehung());
            }
        }
        ,
        naechstePegelschau("naechstePegelschau"){

            @Override
            public OutputView htmlView(\u00dcbersichtsRepository repository, String authToken) {
                return new PegelMitN\u00e4chsterPegelschau(repository.pegelMitN\u00e4chsterPegelschau());
            }
        }
        ,
        offeneMassnahmen("offeneMassnahmen"){

            @Override
            public OutputView htmlView(\u00dcbersichtsRepository repository, String authToken) {
                return new Sonstige\u00dcbersicht("\u00dcbersicht \u00fcber alle Pegel mit offenen Ma\u00dfnahmen", "core/report/with_open_measures", authToken);
            }
        }
        ,
        aktiveWorkflows("aktiveWorkflows"){

            @Override
            public OutputView htmlView(\u00dcbersichtsRepository repository, String authToken) {
                return new Sonstige\u00dcbersicht("\u00dcbersicht \u00fcber alle Pegel mit aktiven Workflows", "core/report/with_active_workflows", authToken);
            }
        }
        ,
        ruecklaeufeDatenpruefungen("ruecklaeufeDatenpruefungen"){

            @Override
            public OutputView htmlView(\u00dcbersichtsRepository repository, String authToken) {
                return new Sonstige\u00dcbersicht("\u00dcbersicht der R\u00fcckl\u00e4ufe der RP-Datenpr\u00fcfungen", "core/return_for_data_checks", authToken);
            }
        }
        ,
        abweichungenRegel("abweichungenRegel"){

            @Override
            public OutputView htmlView(\u00dcbersichtsRepository repository, String authToken) {
                return new Sonstige\u00dcbersicht("\u00dcbersicht \u00fcber alle Pegel mit Abweichungen von der Regel", "core/report/with_anomalies", authToken);
            }
        }
        ,
        tabelleGeraeteinspektion("tabelleGeraeteinspektion"){

            @Override
            public OutputView htmlView(\u00dcbersichtsRepository repository, String authToken) {
                return new Sonstige\u00dcbersicht("Tabelle f\u00fcr Ger\u00e4teinspektion", "core/device_inspection_sheet", authToken);
            }
        };

        private final String key;

        private \u00dcbersichtsTyp(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public abstract OutputView htmlView(\u00dcbersichtsRepository var1, String var2);

        public static Optional<\u00dcbersichtsTyp> ausKey(String key) {
            for (\u00dcbersichtsTyp typ : \u00dcbersichtsTyp.values()) {
                if (!Objects.equals(typ.key(), key)) continue;
                return Optional.of(typ);
            }
            return Optional.empty();
        }
    }
}

