/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.Arrays;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.model.SteckbriefTyp;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.pdf.Steckbrief;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SteckbriefHandler
extends OutputHandler {
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern("yyyy-MM-dd").withZone(DateTimeZone.forOffsetHours(1));

    public SteckbriefHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("station", "type", "auth_token");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        long messstellenNummer = params.mandatoryLong("station");
        SteckbriefTyp typ = SteckbriefTyp.f\u00fcrKey(params.mandatoryString("type")).orElse(SteckbriefTyp.pegel);
        String authToken = params.mandatoryString("auth_token");
        return new Steckbrief(messstellenNummer, typ, authToken);
    }
}

