/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.Arrays;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.text.Pegelnotizen;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class PegelnotizenHandler
extends OutputHandler {
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern("yyyy-MM-dd").withZone(DateTimeZone.forOffsetHours(1));

    public PegelnotizenHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("station", "start", "end");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) throws Exception {
        long messstellenNummer = params.mandatoryLong("station");
        DateTime von = dateFormat.parseDateTime(params.mandatoryString("start")).withTime(0, 0, 0, 0);
        DateTime bis = dateFormat.parseDateTime(params.mandatoryString("end")).withTime(23, 59, 59, 999);
        long benutzerId = params.mandatoryLong("user_id");
        Pegelnotizen.Model model = Pegelnotizen.Model.lade(datenRepository, messstellenNummer, new Interval((ReadableInstant)von, (ReadableInstant)bis), benutzerId);
        return new Pegelnotizen(model, this.trennzeichen(params));
    }
}

