/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.Arrays;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.html.Monatstabelle;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;

public class MonatstabelleHandler
extends OutputHandler {
    public MonatstabelleHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("station", "year", "month", "parameter", "user_id");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        long messstellenNummer = params.mandatoryLong("station");
        int year = params.mandatoryInt("year");
        int month = params.mandatoryInt("month");
        long benutzerId = params.mandatoryLong("user_id");
        Parameter parameter = Parameter.valueOf(params.mandatoryString("parameter"));
        WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he = WasserstandBezugsh\u00f6he.NHNIfTrue(params.optionalBoolean("nhn"));
        return new Monatstabelle(messstellenNummer, benutzerId, AbflussOderWasserstand.fromParameter(parameter), new YearMonth(year, month), datenRepository, wasserstandBezugsh\u00f6he);
    }
}

