/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.awt.Color;
import java.util.Arrays;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.model.Aufl\u00f6sung;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.pdf.Monatsgrafik;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;

public class MonatsgrafikHandler
extends OutputHandler {
    public MonatsgrafikHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("station", "year", "month", "parameter", "color", "resolution");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        long messstellenNummer = params.mandatoryLong("station");
        int year = params.mandatoryInt("year");
        int month = params.mandatoryInt("month");
        Parameter parameter = Parameter.valueOf(params.mandatoryString("parameter"));
        Color color = params.mandatoryColor("color");
        Aufl\u00f6sung aufl\u00f6sung = Aufl\u00f6sung.fromKey(params.mandatoryString("resolution"));
        return new Monatsgrafik(messstellenNummer, parameter, new YearMonth(year, month), datenRepository, color, aufl\u00f6sung);
    }
}

