/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.DatenRepositoryMitVerkettung;
import luwa.marlin.ship_library.view.text.MQundMNQ;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class MQundMNQHandler
extends OutputHandler {
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern("yyyy-MM-dd").withZone(DateTimeZone.forOffsetHours(1));

    public MQundMNQHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("stations", "start", "end");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        List<Long> messstellenNummern = params.mandatoryLongList("stations");
        DateTime start = dateFormat.parseDateTime(params.mandatoryString("start")).withTime(0, 0, 0, 0);
        DateTime end = dateFormat.parseDateTime(params.mandatoryString("end")).withTime(23, 59, 59, 999);
        Interval zeitraum = new Interval((ReadableInstant)start, (ReadableInstant)end);
        Trennzeichen trennzeichen = this.trennzeichen(params);
        return new MQundMNQ(new DatenRepositoryMitVerkettung(datenRepository), messstellenNummern, zeitraum, trennzeichen);
    }
}

