/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.awt.Color;
import java.util.Arrays;
import java.util.Optional;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.model.Aufl\u00f6sung;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.DatenRepositoryMitVerkettung;
import luwa.marlin.ship_library.view.pdf.Jahresgrafik;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;

public class JahresgrafikHandler
extends OutputHandler {
    public JahresgrafikHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("station", "year", "parameter", "color", "resolution");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        long messstellenNummer = params.mandatoryLong("station");
        int year = params.mandatoryInt("year");
        Parameter parameter = Parameter.valueOf(params.mandatoryString("parameter"));
        Color color = params.mandatoryColor("color");
        Aufl\u00f6sung aufl\u00f6sung = Aufl\u00f6sung.fromKey(params.mandatoryString("resolution"));
        boolean useCalendarYear = params.optionalBoolean("use_calendar_year");
        Optional<Integer> wMin = params.optionalInt("w_min");
        Optional<Integer> wMax = params.optionalInt("w_max");
        boolean withPre = params.optionalBoolean("with_pre");
        WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he = WasserstandBezugsh\u00f6he.NHNIfTrue(params.optionalBoolean("nhn"));
        DatenRepository source = parameter == Parameter.q && withPre ? new DatenRepositoryMitVerkettung(datenRepository) : datenRepository;
        return new Jahresgrafik(messstellenNummer, parameter, useCalendarYear ? new Kalenderjahr(year) : new Abflussjahr(year), source, color, aufl\u00f6sung, wMin, wMax, wasserstandBezugsh\u00f6he);
    }
}

