/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.Arrays;
import java.util.Optional;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.JahrbuchModus;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.model.JahrbuchseitenConfiguration;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.UnzureichendeDatenlage;
import luwa.marlin.ship_library.view.JahrbuchseiteRenderModel;
import luwa.marlin.ship_library.view.pdf.JahrbuchseitePDF;
import luwa.marlin.ship_library.view.text.PDFErrorPage;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;

public class JahrbuchseiteHandler
extends OutputHandler {
    public JahrbuchseiteHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("station", "from_year", "to_year", "parameter", "user_id");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) throws Exception {
        long messstellenNummer = params.mandatoryLong("station");
        int vonJahr = params.mandatoryInt("from_year");
        int bisJahr = params.mandatoryInt("to_year");
        AbflussOderWasserstand abflussOderWasserstand = AbflussOderWasserstand.fromString(params.mandatoryString("parameter"));
        long benutzerId = params.mandatoryLong("user_id");
        JahrbuchModus modus = params.optionalString("modus").flatMap(JahrbuchModus::fromKey).orElse(JahrbuchModus.analog);
        Optional<Integer> jahr = params.optionalInt("year");
        WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he = WasserstandBezugsh\u00f6he.NHNIfTrue(params.optionalBoolean("nhn"));
        JahrbuchseitenConfiguration config = new JahrbuchseitenConfiguration(messstellenNummer, Optional.of(benutzerId), vonJahr, bisJahr, abflussOderWasserstand, modus, jahr, wasserstandBezugsh\u00f6he);
        Jahrbuchseite jahrbuchseite = new Jahrbuchseite(config, datenRepository);
        try {
            return new JahrbuchseitePDF(new JahrbuchseiteRenderModel(jahrbuchseite));
        }
        catch (UnzureichendeDatenlage unzureichendeDatenlage) {
            return new PDFErrorPage(unzureichendeDatenlage, wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170);
        }
    }
}

