/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.DatenRepositoryMitVerkettung;
import luwa.marlin.ship_library.view.text.HochwasserJ\u00e4hrlichkeiten;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class HochwasserJ\u00e4hrlichkeitenHandler
extends OutputHandler {
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern("yyyy-MM-dd").withZone(DateTimeZone.forOffsetHours(1));

    public HochwasserJ\u00e4hrlichkeitenHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("stations", "start_year", "end_year", "hw_start_day", "hw_end_day", "additional_top_n");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        List<Long> messstellenNummern = params.mandatoryLongList("stations");
        int startYear = params.mandatoryInt("start_year");
        int endYear = params.mandatoryInt("end_year");
        DateTime hwStart = dateFormat.parseDateTime(params.mandatoryString("hw_start_day")).withTime(0, 0, 0, 0);
        DateTime hwEnd = dateFormat.parseDateTime(params.mandatoryString("hw_end_day")).withTime(23, 59, 59, 999);
        Interval hwInterval = new Interval((ReadableInstant)hwStart, (ReadableInstant)hwEnd);
        int additionalTopN = params.mandatoryInt("additional_top_n");
        HochwasserJ\u00e4hrlichkeiten.Configuration configuration = new HochwasserJ\u00e4hrlichkeiten.Configuration(messstellenNummern, startYear, endYear, hwInterval, additionalTopN);
        return new HochwasserJ\u00e4hrlichkeiten(new DatenRepositoryMitVerkettung(datenRepository), configuration);
    }
}

