/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import luwa.marlin.web.health.Healthcheck;

public class HealthHandler
implements HttpHandler {
    private final DataSource database;

    public HealthHandler(DataSource database) {
        this.database = database;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json; charset=utf-8");
        Healthcheck.Status determinedHealth = Healthcheck.Status.good;
        if (!this.isDatabaseReachable()) {
            determinedHealth = Healthcheck.Status.bad;
        }
        exchange.getResponseSender().send(Healthcheck.overallHealthAs(determinedHealth));
    }

    private boolean isDatabaseReachable() {
        boolean bl;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                bl = connection.isValid(250);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e2) {
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }
}

