/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Optional;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.DatenF\u00fcrJahrbuchseite;
import luwa.marlin.ship_library.model.Hauptwerte;
import luwa.marlin.ship_library.model.JahrbuchseitenConfiguration;
import luwa.marlin.ship_library.model.Jahreshauptwerte;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.text.HauptwerteJson;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;

public class HauptwerteHandler
extends OutputHandler {
    public HauptwerteHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("station", "from_year", "to_year", "parameter");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) throws Exception {
        long messstellenNummer = params.mandatoryLong("station");
        int vonJahr = params.mandatoryInt("from_year");
        int bisJahr = params.mandatoryInt("to_year");
        AbflussOderWasserstand abflussOderWasserstand = AbflussOderWasserstand.fromString(params.mandatoryString("parameter"));
        JahrbuchseitenConfiguration config = new JahrbuchseitenConfiguration(messstellenNummer, Optional.empty(), vonJahr, bisJahr, abflussOderWasserstand);
        DatenF\u00fcrJahrbuchseite daten = new DatenF\u00fcrJahrbuchseite(config, datenRepository);
        Hauptwerte hauptwerte = daten.hauptwerte();
        Hauptwerte.mehrj\u00e4hrigeHauptwerte jahreshauptwerte = hauptwerte.yearsRangeMainValues(vonJahr, bisJahr);
        Jahreshauptwerte result = new Jahreshauptwerte(this.format(jahreshauptwerte.jahreswert(Hauptwerte.Art.N).value().orElse(0.0), abflussOderWasserstand), jahreshauptwerte.jahreswert(Hauptwerte.Art.N).jahr().orElse(1000), this.format(jahreshauptwerte.jahreswert(Hauptwerte.Art.MN).value().orElse(0.0), abflussOderWasserstand), this.format(jahreshauptwerte.jahreswert(Hauptwerte.Art.M).value().orElse(0.0), abflussOderWasserstand), this.format(jahreshauptwerte.jahreswert(Hauptwerte.Art.MH).value().orElse(0.0), abflussOderWasserstand), this.format(jahreshauptwerte.jahreswert(Hauptwerte.Art.H).value().orElse(0.0), abflussOderWasserstand), jahreshauptwerte.jahreswert(Hauptwerte.Art.H).jahr().orElse(1000), this.format(hauptwerte.NN().value().orElse(0.0), abflussOderWasserstand), hauptwerte.NN().timestampedValue().map(TimestampedValue::timestamp).orElse(null), this.format(hauptwerte.HH().value().orElse(0.0), abflussOderWasserstand), hauptwerte.HH().timestampedValue().map(TimestampedValue::timestamp).orElse(null));
        return new HauptwerteJson(result);
    }

    private double format(double wert, AbflussOderWasserstand abflussOderWasserstand) {
        int precision = 1;
        if (wert >= 10.0) {
            precision = 2;
        }
        if (wert >= 100.0) {
            precision = 3;
        }
        if (wert >= 1000.0) {
            precision = 4;
        }
        if (abflussOderWasserstand == AbflussOderWasserstand.Q) {
            precision += 4;
        }
        BigDecimal bd = new BigDecimal(wert);
        return bd.round(new MathContext(precision)).doubleValue();
    }
}

