/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.text.AbflussmessungenStatistik;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AbflussmessungenStatistikHandler
extends OutputHandler {
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern("yyyy-MM-dd").withZone(DateTimeZone.forOffsetHours(1));

    public AbflussmessungenStatistikHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("stations", "start_year", "end_year");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        List<Long> messstellenNummern = params.mandatoryLongList("stations");
        int jahrVon = params.mandatoryInt("start_year");
        int jahrBis = params.mandatoryInt("end_year");
        List<Long> sortierteMessstellenNummern = messstellenNummern.stream().sorted().distinct().collect(Collectors.toList());
        return new AbflussmessungenStatistik(datenRepository, sortierteMessstellenNummern, jahrVon, jahrBis, this.trennzeichen(params));
    }
}

