/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.sql.SQLDatenRepository;
import luwa.marlin.ship_library.util.Benchmark;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;

public abstract class OutputHandler
implements HttpHandler {
    private final DataSource dataSource;

    public OutputHandler(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        Parameters params = new Parameters(exchange.getQueryParameters());
        List missingParams = StreamSupport.stream(this.mandatoryParams().spliterator(), false).filter(paramName -> !params.exists((String)paramName)).collect(Collectors.toList());
        if (!missingParams.isEmpty()) {
            System.out.println("Fehlende(r) URL-Query-Parameter: " + String.join((CharSequence)", ", missingParams));
            return;
        }
        try (Connection connection = this.dataSource.getConnection();){
            SQLDatenRepository datenRepository = new SQLDatenRepository(connection);
            OutputView view = this.createView(params, datenRepository);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, view.contentType() + "; charset=" + view.charset());
            exchange.startBlocking();
            Benchmark.benchmark("Rendern von '" + view.name() + "'", () -> {
                try {
                    view.writeTo(exchange.getOutputStream());
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw e2;
                }
            });
        }
    }

    protected abstract Iterable<String> mandatoryParams();

    protected abstract OutputView createView(Parameters var1, DatenRepository var2) throws Exception;

    protected Trennzeichen trennzeichen(Parameters params) {
        return params.optionalString("separator").flatMap(Trennzeichen::fromKey).orElse(Trennzeichen.tabulator);
    }
}

