/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.json;

import com.fasterxml.jackson.core.util.BufferRecyclers;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;

public final class JsonHelpers {
    public static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm");
    public static final String quotedNaN = "\"NaN\"";

    public static String formatDate(ZonedDateTime timestamp) {
        return JsonHelpers.formatDate(Optional.ofNullable(timestamp));
    }

    public static String formatDate(Optional<ZonedDateTime> timestamp) {
        if (timestamp.isEmpty()) {
            return null;
        }
        ZonedDateTime utcTimestamp = timestamp.get().withZoneSameInstant(ZoneId.of("UTC"));
        return dateFormat.format(utcTimestamp) + "T" + timeFormat.format(utcTimestamp) + "Z";
    }

    public static char[] escapeString(String s2) {
        if (s2 == null) {
            s2 = "";
        }
        return BufferRecyclers.getJsonStringEncoder().quoteAsString(s2);
    }

    public static String formatDoubleValue(Double value) {
        if (value == null || value.isNaN()) {
            return quotedNaN;
        }
        return String.valueOf(value);
    }

    public static String getTrimmedString(Map jsonData, String name) {
        Object value = jsonData.get(name);
        if (null == value) {
            return "";
        }
        return ((String)value).trim();
    }
}

