/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.database.generic;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import luwa.marlin.database.generic.MarlinOracleDataSource;
import luwa.marlin.database.generic.MarlinPostgresDataSource;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DatabaseSystem {
    oracle("jdbc:oracle"){

        @Override
        public DataSource createDataSource(String url, String user, String password, long readTimeoutMilliseconds) throws SQLException {
            return MarlinOracleDataSource.createFor(url, user, password, readTimeoutMilliseconds);
        }
    }
    ,
    postgres("jdbc:postgresql"){

        @Override
        public DataSource createDataSource(String url, String user, String password, long readTimeoutMilliseconds) throws SQLException {
            return MarlinPostgresDataSource.createFor(url, user, password, readTimeoutMilliseconds);
        }
    };

    private final String connectionStringPrefix;

    private DatabaseSystem(String connectionStringPrefix) {
        this.connectionStringPrefix = connectionStringPrefix;
    }

    public abstract DataSource createDataSource(String var1, String var2, String var3, long var4) throws SQLException;

    public static Optional<DatabaseSystem> fromConnection(Connection connection) throws SQLException {
        return DatabaseSystem.fromURL(connection.getMetaData().getURL());
    }

    public static Optional<DatabaseSystem> fromURL(String url) {
        for (DatabaseSystem system : DatabaseSystem.values()) {
            if (!url.startsWith(system.connectionStringPrefix)) continue;
            return Optional.of(system);
        }
        return Optional.empty();
    }
}

