/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.configuration;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import luwa.marlin.logging.Logger;

public class Environment {
    private final Map<String, String> variables;

    public Environment(Map<String, String> variables) {
        this.variables = variables;
    }

    public static Environment fromSystem() {
        return new Environment(System.getenv());
    }

    public Optional<String> valueOf(String variable) {
        return this.valueOf(variable, (String v2) -> Logger.log().warn("Required environment variable " + v2 + " for service configuration is not set!"));
    }

    public String valueOf(String variable, String fallback) {
        return this.valueOf(variable, () -> fallback);
    }

    public String valueOf(String variable, Supplier<String> fallback) {
        return this.valueOf(variable, (String v2) -> Logger.log().info("Environment variable " + v2 + " for service configuration is not set, using fallback: " + (String)fallback.get())).orElseGet(fallback);
    }

    private Optional<String> valueOf(String variable, LogVariableMiss log) {
        if (this.variables.containsKey(variable)) {
            return Optional.ofNullable(this.variables.get(variable));
        }
        log.notThere(variable);
        return Optional.empty();
    }

    @FunctionalInterface
    private static interface LogVariableMiss {
        public void notThere(String var1);
    }
}

