/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.configuration;

import luwa.marlin.component.Component;
import luwa.marlin.configuration.Environment;

public class ConfiguredNetwork {
    private static final String hostVariableTemplate = "MARLIN_BIND_HOST";
    private static final String portVariableTemplate = "MARLIN_$SERVICENAME$_PORT";
    private static final String defaultHost = "localhost";
    private final String host;
    private final int port;

    public ConfiguredNetwork(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static ConfiguredNetwork forService(Component service) {
        return ConfiguredNetwork.fromSystemEnvironmentFor(service.serviceName(), service.defaultPort());
    }

    private static ConfiguredNetwork fromSystemEnvironmentFor(String serviceName, int defaultPort) {
        return ConfiguredNetwork.from(Environment.fromSystem(), serviceName, defaultPort);
    }

    protected static ConfiguredNetwork from(Environment environment, String serviceName, int defaultPort) {
        return new ConfiguredNetwork(environment.valueOf(ConfiguredNetwork.evaluate(hostVariableTemplate, serviceName), defaultHost), Integer.parseInt(environment.valueOf(ConfiguredNetwork.evaluate(portVariableTemplate, serviceName), () -> String.valueOf(defaultPort))));
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String protocol() {
        return this.port() == 80 ? "http" : "https";
    }

    private static String evaluate(String template, String replacement) {
        return template.replace("$SERVICENAME$", replacement.toUpperCase());
    }
}

