/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.websockets.core.function.ChannelFunction;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import java.nio.ByteBuffer;

public final class Masker
implements ChannelFunction {
    private byte[] maskingKey;
    int m;

    Masker(int maskingKey) {
        this.maskingKey = Masker.createsMaskingKey(maskingKey);
    }

    public void setMaskingKey(int maskingKey) {
        this.maskingKey = Masker.createsMaskingKey(maskingKey);
        this.m = 0;
    }

    private static byte[] createsMaskingKey(int maskingKey) {
        byte[] key = new byte[]{(byte)(maskingKey >> 24 & 0xFF), (byte)(maskingKey >> 16 & 0xFF), (byte)(maskingKey >> 8 & 0xFF), (byte)(maskingKey & 0xFF)};
        return key;
    }

    private void mask(ByteBuffer buf, int position, int length) {
        int limit = position + length;
        for (int i2 = position; i2 < limit; ++i2) {
            buf.put(i2, (byte)(buf.get(i2) ^ this.maskingKey[this.m++]));
            this.m %= 4;
        }
    }

    @Override
    public void newFrame(FrameHeaderData headerData) {
        WebSocket07Channel.WebSocketFrameHeader header = (WebSocket07Channel.WebSocketFrameHeader)headerData;
        this.setMaskingKey(header.getMaskingKey());
    }

    @Override
    public void afterRead(ByteBuffer buf, int position, int length) {
        this.mask(buf, position, length);
    }

    @Override
    public void beforeWrite(ByteBuffer buf, int position, int length) {
        this.mask(buf, position, length);
    }

    @Override
    public void complete() {
    }
}

