/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.util.ImmediatePooled;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xnio.ChannelListener;
import org.xnio.Pooled;

public class BufferedBinaryMessage {
    private final boolean bufferFullMessage;
    private List<PooledByteBuffer> data = new ArrayList<PooledByteBuffer>(1);
    private PooledByteBuffer current;
    private final long maxMessageSize;
    private long currentSize;
    private boolean complete;

    public BufferedBinaryMessage(long maxMessageSize, boolean bufferFullMessage) {
        this.bufferFullMessage = bufferFullMessage;
        this.maxMessageSize = maxMessageSize;
    }

    public BufferedBinaryMessage(boolean bufferFullMessage) {
        this(-1L, bufferFullMessage);
    }

    public void readBlocking(StreamSourceFrameChannel channel) throws IOException {
        if (this.current == null) {
            this.current = channel.getWebSocketChannel().getBufferPool().allocate();
        }
        while (true) {
            int res;
            if ((res = channel.read(this.current.getBuffer())) == -1) {
                this.complete = true;
                return;
            }
            if (res == 0) {
                channel.awaitReadable();
            }
            this.checkMaxSize(channel, res);
            if (this.bufferFullMessage) {
                this.dealWithFullBuffer(channel);
                continue;
            }
            if (!this.current.getBuffer().hasRemaining()) break;
        }
    }

    private void dealWithFullBuffer(StreamSourceFrameChannel channel) {
        if (!this.current.getBuffer().hasRemaining()) {
            this.current.getBuffer().flip();
            this.data.add(this.current);
            this.current = channel.getWebSocketChannel().getBufferPool().allocate();
        }
    }

    public void read(StreamSourceFrameChannel channel, final WebSocketCallback<BufferedBinaryMessage> callback) {
        try {
            while (true) {
                int res;
                if (this.current == null) {
                    this.current = channel.getWebSocketChannel().getBufferPool().allocate();
                }
                if ((res = channel.read(this.current.getBuffer())) == -1) {
                    this.complete = true;
                    callback.complete(channel.getWebSocketChannel(), this);
                    return;
                }
                if (res == 0) {
                    if (!this.bufferFullMessage) {
                        callback.complete(channel.getWebSocketChannel(), this);
                    }
                    channel.getReadSetter().set(new ChannelListener<StreamSourceFrameChannel>(){

                        @Override
                        public void handleEvent(StreamSourceFrameChannel channel) {
                            if (BufferedBinaryMessage.this.complete) {
                                return;
                            }
                            try {
                                while (true) {
                                    int res;
                                    if (BufferedBinaryMessage.this.current == null) {
                                        BufferedBinaryMessage.this.current = channel.getWebSocketChannel().getBufferPool().allocate();
                                    }
                                    if ((res = channel.read(BufferedBinaryMessage.this.current.getBuffer())) == -1) {
                                        BufferedBinaryMessage.this.complete = true;
                                        channel.suspendReads();
                                        callback.complete(channel.getWebSocketChannel(), BufferedBinaryMessage.this);
                                        return;
                                    }
                                    if (res == 0) {
                                        return;
                                    }
                                    BufferedBinaryMessage.this.checkMaxSize(channel, res);
                                    if (BufferedBinaryMessage.this.bufferFullMessage) {
                                        BufferedBinaryMessage.this.dealWithFullBuffer(channel);
                                        continue;
                                    }
                                    if (BufferedBinaryMessage.this.current.getBuffer().hasRemaining()) continue;
                                    callback.complete(channel.getWebSocketChannel(), BufferedBinaryMessage.this);
                                }
                            }
                            catch (IOException e2) {
                                channel.suspendReads();
                                callback.onError(channel.getWebSocketChannel(), BufferedBinaryMessage.this, e2);
                                return;
                            }
                        }
                    });
                    channel.resumeReads();
                    return;
                }
                this.checkMaxSize(channel, res);
                if (this.bufferFullMessage) {
                    this.dealWithFullBuffer(channel);
                    continue;
                }
                if (this.current.getBuffer().hasRemaining()) continue;
                callback.complete(channel.getWebSocketChannel(), this);
            }
        }
        catch (IOException e2) {
            callback.onError(channel.getWebSocketChannel(), this, e2);
            return;
        }
    }

    private void checkMaxSize(StreamSourceFrameChannel channel, int res) throws IOException {
        this.currentSize += (long)res;
        if (this.maxMessageSize > 0L && this.currentSize > this.maxMessageSize) {
            this.getData().free();
            WebSockets.sendClose(new CloseMessage(1009, WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize)), channel.getWebSocketChannel(), null);
            throw new IOException(WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize));
        }
    }

    public Pooled<ByteBuffer[]> getData() {
        if (this.current == null) {
            return new ImmediatePooled<ByteBuffer[]>(new ByteBuffer[0]);
        }
        if (this.data.isEmpty()) {
            PooledByteBuffer current = this.current;
            current.getBuffer().flip();
            this.current = null;
            ByteBuffer[] data = new ByteBuffer[]{current.getBuffer()};
            return new PooledByteBufferArray(Collections.singletonList(current), data);
        }
        this.current.getBuffer().flip();
        this.data.add(this.current);
        this.current = null;
        ByteBuffer[] ret = new ByteBuffer[this.data.size()];
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            ret[i2] = this.data.get(i2).getBuffer();
        }
        List<PooledByteBuffer> data = this.data;
        this.data = new ArrayList<PooledByteBuffer>();
        return new PooledByteBufferArray(data, ret);
    }

    public boolean isComplete() {
        return this.complete;
    }

    private static final class PooledByteBufferArray
    implements Pooled<ByteBuffer[]> {
        private final List<PooledByteBuffer> pooled;
        private final ByteBuffer[] data;

        private PooledByteBufferArray(List<PooledByteBuffer> pooled, ByteBuffer[] data) {
            this.pooled = pooled;
            this.data = data;
        }

        @Override
        public void discard() {
            for (PooledByteBuffer item : this.pooled) {
                item.close();
            }
        }

        @Override
        public void free() {
            for (PooledByteBuffer item : this.pooled) {
                item.close();
            }
        }

        @Override
        public ByteBuffer[] getResource() throws IllegalStateException {
            return this.data;
        }

        @Override
        public void close() {
            this.free();
        }
    }
}

