/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QValueParser {
    private QValueParser() {
    }

    public static List<List<QValueResult>> parse(List<String> headers) {
        ArrayList<QValueResult> found = new ArrayList<QValueResult>();
        QValueResult current = null;
        for (int j2 = 0; j2 < headers.size(); ++j2) {
            String header = headers.get(j2);
            int l2 = header.length();
            int stringStart = 0;
            block6: for (int i2 = 0; i2 < l2; ++i2) {
                char c2 = header.charAt(i2);
                switch (c2) {
                    case ',': {
                        if (current != null && i2 - stringStart > 2 && header.charAt(stringStart) == 'q' && header.charAt(stringStart + 1) == '=') {
                            current.qvalue = header.substring(stringStart + 2, i2);
                            current = null;
                        } else if (stringStart != i2) {
                            current = QValueParser.handleNewEncoding(found, header, stringStart, i2);
                        }
                        stringStart = i2 + 1;
                        continue block6;
                    }
                    case ';': {
                        if (stringStart == i2) continue block6;
                        current = QValueParser.handleNewEncoding(found, header, stringStart, i2);
                        stringStart = i2 + 1;
                        continue block6;
                    }
                    case ' ': {
                        if (stringStart != i2) {
                            if (current != null && i2 - stringStart > 2 && header.charAt(stringStart) == 'q' && header.charAt(stringStart + 1) == '=') {
                                current.qvalue = header.substring(stringStart + 2, i2);
                            } else {
                                current = QValueParser.handleNewEncoding(found, header, stringStart, i2);
                            }
                        }
                        stringStart = i2 + 1;
                    }
                }
            }
            if (stringStart == l2) continue;
            if (current != null && l2 - stringStart > 2 && header.charAt(stringStart) == 'q' && header.charAt(stringStart + 1) == '=') {
                current.qvalue = header.substring(stringStart + 2, l2);
                continue;
            }
            current = QValueParser.handleNewEncoding(found, header, stringStart, l2);
        }
        Collections.sort(found, Collections.reverseOrder());
        String currentQValue = null;
        ArrayList<List<QValueResult>> values = new ArrayList<List<QValueResult>>();
        ArrayList<QValueResult> currentSet = null;
        for (int i3 = 0; i3 < found.size(); ++i3) {
            QValueResult val = (QValueResult)found.get(i3);
            if (!val.qvalue.equals(currentQValue)) {
                currentQValue = val.qvalue;
                currentSet = new ArrayList<QValueResult>();
                values.add(currentSet);
            }
            currentSet.add(val);
        }
        return values;
    }

    private static QValueResult handleNewEncoding(List<QValueResult> found, String header, int stringStart, int i2) {
        QValueResult current = new QValueResult();
        current.value = header.substring(stringStart, i2);
        found.add(current);
        return current;
    }

    public static class QValueResult
    implements Comparable<QValueResult> {
        private String value;
        private String qvalue = "1";

        public String getValue() {
            return this.value;
        }

        public String getQvalue() {
            return this.qvalue;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof QValueResult)) {
                return false;
            }
            QValueResult that = (QValueResult)o2;
            if (this.getValue() != null ? !this.getValue().equals(that.getValue()) : that.getValue() != null) {
                return false;
            }
            return this.getQvalue() != null ? this.getQvalue().equals(that.getQvalue()) : that.getQvalue() == null;
        }

        public int hashCode() {
            int result = this.getValue() != null ? this.getValue().hashCode() : 0;
            result = 31 * result + (this.getQvalue() != null ? this.getQvalue().hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(QValueResult other) {
            String t2 = this.qvalue;
            String o2 = other.qvalue;
            if (t2 == null && o2 == null) {
                return 0;
            }
            if (o2 == null) {
                return 1;
            }
            if (t2 == null) {
                return -1;
            }
            int tl = t2.length();
            int ol = o2.length();
            for (int i2 = 0; i2 < 5; ++i2) {
                char oc;
                char tc;
                int res;
                if (tl == i2 || ol == i2) {
                    return ol - tl;
                }
                if (i2 == 1 || (res = (tc = t2.charAt(i2)) - (oc = o2.charAt(i2))) == 0) continue;
                return res;
            }
            return 0;
        }

        public boolean isQValueZero() {
            if (this.qvalue != null) {
                int length = Math.min(5, this.qvalue.length());
                boolean zero = true;
                for (int j2 = 0; j2 < length; ++j2) {
                    if (j2 == 1 || this.qvalue.charAt(j2) == '0') continue;
                    zero = false;
                    break;
                }
                return zero;
            }
            return false;
        }
    }
}

