/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.ConcurrentDirectDeque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.wildfly.common.Assert;

public class FastConcurrentDirectDeque<E>
extends ConcurrentDirectDeque<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final Node<Object> PREV_TERMINATOR = new Node();
    private static final Node<Object> NEXT_TERMINATOR;
    private static final int HOPS = 2;
    private static final VarHandle HEAD;
    private static final VarHandle TAIL;
    private static final VarHandle PREV;
    private static final VarHandle NEXT;
    private static final VarHandle ITEM;

    Node<E> prevTerminator() {
        return PREV_TERMINATOR;
    }

    Node<E> nextTerminator() {
        return NEXT_TERMINATOR;
    }

    static <E> Node<E> newNode(E item) {
        Node node = new Node();
        ITEM.set(node, item);
        return node;
    }

    private Node linkFirst(E e2) {
        Node<E> p2;
        Node<E> h2;
        Node<E> newNode = FastConcurrentDirectDeque.newNode(Objects.requireNonNull(e2));
        block0: while (true) {
            p2 = h2 = this.head;
            while (true) {
                Node q2;
                if ((q2 = p2.prev) != null) {
                    p2 = q2;
                    q2 = p2.prev;
                    if (q2 != null) {
                        p2 = h2 != (h2 = this.head) ? h2 : q2;
                        continue;
                    }
                }
                if (p2.next == p2) continue block0;
                NEXT.set(newNode, p2);
                if (PREV.compareAndSet(p2, null, newNode)) break block0;
            }
            break;
        }
        if (p2 != h2) {
            HEAD.weakCompareAndSet(this, h2, newNode);
        }
        return newNode;
    }

    private Node linkLast(E e2) {
        Node<E> p2;
        Node<E> t2;
        Node<E> newNode = FastConcurrentDirectDeque.newNode(Objects.requireNonNull(e2));
        block0: while (true) {
            p2 = t2 = this.tail;
            while (true) {
                Node q2;
                if ((q2 = p2.next) != null) {
                    p2 = q2;
                    q2 = p2.next;
                    if (q2 != null) {
                        p2 = t2 != (t2 = this.tail) ? t2 : q2;
                        continue;
                    }
                }
                if (p2.prev == p2) continue block0;
                PREV.set(newNode, p2);
                if (NEXT.compareAndSet(p2, null, newNode)) break block0;
            }
            break;
        }
        if (p2 != t2) {
            TAIL.weakCompareAndSet(this, t2, newNode);
        }
        return newNode;
    }

    void unlink(Node<E> x2) {
        Node prev = x2.prev;
        Node next = x2.next;
        if (prev == null) {
            this.unlinkFirst(x2, next);
        } else if (next == null) {
            this.unlinkLast(x2, prev);
        } else {
            boolean isLast;
            Node activeSucc;
            Node q2;
            boolean isFirst;
            Node activePred;
            int hops = 1;
            Node p2 = prev;
            while (true) {
                if (p2.item != null) {
                    activePred = p2;
                    isFirst = false;
                    break;
                }
                q2 = p2.prev;
                if (q2 == null) {
                    if (p2.next == p2) {
                        return;
                    }
                    activePred = p2;
                    isFirst = true;
                    break;
                }
                if (p2 == q2) {
                    return;
                }
                p2 = q2;
                ++hops;
            }
            p2 = next;
            while (true) {
                if (p2.item != null) {
                    activeSucc = p2;
                    isLast = false;
                    break;
                }
                q2 = p2.next;
                if (q2 == null) {
                    if (p2.prev == p2) {
                        return;
                    }
                    activeSucc = p2;
                    isLast = true;
                    break;
                }
                if (p2 == q2) {
                    return;
                }
                p2 = q2;
                ++hops;
            }
            if (hops < 2 && isFirst | isLast) {
                return;
            }
            this.skipDeletedSuccessors(activePred);
            this.skipDeletedPredecessors(activeSucc);
            if (isFirst | isLast && activePred.next == activeSucc && activeSucc.prev == activePred && (isFirst ? activePred.prev == null : activePred.item != null) && (isLast ? activeSucc.next == null : activeSucc.item != null)) {
                this.updateHead();
                this.updateTail();
                PREV.setRelease(x2, isFirst ? this.prevTerminator() : x2);
                NEXT.setRelease(x2, isLast ? this.nextTerminator() : x2);
            }
        }
    }

    private void unlinkFirst(Node<E> first, Node<E> next) {
        Node<E> o2 = null;
        Node<E> p2 = next;
        while (true) {
            Node q2;
            if (p2.item != null || (q2 = p2.next) == null) {
                if (o2 != null && p2.prev != p2 && NEXT.compareAndSet(first, next, p2)) {
                    this.skipDeletedPredecessors(p2);
                    if (first.prev == null && (p2.next == null || p2.item != null) && p2.prev == first) {
                        this.updateHead();
                        this.updateTail();
                        NEXT.setRelease(o2, o2);
                        PREV.setRelease(o2, this.prevTerminator());
                    }
                }
                return;
            }
            if (p2 == q2) {
                return;
            }
            o2 = p2;
            p2 = q2;
        }
    }

    private void unlinkLast(Node<E> last, Node<E> prev) {
        Node<E> o2 = null;
        Node<E> p2 = prev;
        while (true) {
            Node q2;
            if (p2.item != null || (q2 = p2.prev) == null) {
                if (o2 != null && p2.next != p2 && PREV.compareAndSet(last, prev, p2)) {
                    this.skipDeletedSuccessors(p2);
                    if (last.next == null && (p2.prev == null || p2.item != null) && p2.next == last) {
                        this.updateHead();
                        this.updateTail();
                        PREV.setRelease(o2, o2);
                        NEXT.setRelease(o2, this.nextTerminator());
                    }
                }
                return;
            }
            if (p2 == q2) {
                return;
            }
            o2 = p2;
            p2 = q2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateHead() {
        block0: while (true) {
            h = this.head;
            if (h.item != null || (p = h.prev) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.prev) == null) break block4;
                        p = q;
                        q = p.prev;
                        if (q != null) break block5;
                    }
                    if (!FastConcurrentDirectDeque.HEAD.compareAndSet(this, h, p)) continue block0;
                    return;
                }
                if (h == this.head) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateTail() {
        block0: while (true) {
            t = this.tail;
            if (t.item != null || (p = t.next) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.next) == null) break block4;
                        p = q;
                        q = p.next;
                        if (q != null) break block5;
                    }
                    if (!FastConcurrentDirectDeque.TAIL.compareAndSet(this, t, p)) continue block0;
                    return;
                }
                if (t == this.tail) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    private void skipDeletedPredecessors(Node<E> x2) {
        block0: do {
            Node prev;
            Node p2 = prev = x2.prev;
            while (p2.item == null) {
                Node q2 = p2.prev;
                if (q2 == null) {
                    if (p2.next != p2) break;
                    continue block0;
                }
                if (p2 == q2) continue block0;
                p2 = q2;
            }
            if (prev != p2 && !PREV.compareAndSet(x2, prev, p2)) continue;
            return;
        } while (x2.item != null || x2.next == null);
    }

    private void skipDeletedSuccessors(Node<E> x2) {
        block0: do {
            Node next;
            Node p2 = next = x2.next;
            while (p2.item == null) {
                Node q2 = p2.next;
                if (q2 == null) {
                    if (p2.prev != p2) break;
                    continue block0;
                }
                if (p2 == q2) continue block0;
                p2 = q2;
            }
            if (next != p2 && !NEXT.compareAndSet(x2, next, p2)) continue;
            return;
        } while (x2.item != null || x2.prev == null);
    }

    final Node<E> succ(Node<E> p2) {
        if (p2 == (p2 = p2.next)) {
            p2 = this.first();
        }
        return p2;
    }

    final Node<E> pred(Node<E> p2) {
        Node q2 = p2.prev;
        return p2 == q2 ? this.last() : q2;
    }

    Node<E> first() {
        Node<E> h2;
        Node<E> p2;
        block0: do {
            Node q2;
            p2 = h2 = this.head;
            while ((q2 = p2.prev) != null) {
                p2 = q2;
                q2 = p2.prev;
                if (q2 == null) continue block0;
                p2 = h2 != (h2 = this.head) ? h2 : q2;
            }
        } while (p2 != h2 && !HEAD.compareAndSet(this, h2, p2));
        return p2;
    }

    Node<E> last() {
        Node<E> t2;
        Node<E> p2;
        block0: do {
            Node q2;
            p2 = t2 = this.tail;
            while ((q2 = p2.next) != null) {
                p2 = q2;
                q2 = p2.next;
                if (q2 == null) continue block0;
                p2 = t2 != (t2 = this.tail) ? t2 : q2;
            }
        } while (p2 != t2 && !TAIL.compareAndSet(this, t2, p2));
        return p2;
    }

    private E screenNullResult(E v2) {
        if (v2 == null) {
            throw new NoSuchElementException();
        }
        return v2;
    }

    public FastConcurrentDirectDeque() {
        this.tail = new Node();
        this.head = this.tail;
    }

    public FastConcurrentDirectDeque(Collection<? extends E> c2) {
        Node<E> h2 = null;
        Node<E> t2 = null;
        for (E e2 : c2) {
            Node<E> newNode = FastConcurrentDirectDeque.newNode(Objects.requireNonNull(e2));
            if (h2 == null) {
                h2 = t2 = newNode;
                continue;
            }
            NEXT.set(t2, newNode);
            PREV.set(newNode, t2);
            t2 = newNode;
        }
        this.initHeadTail(h2, t2);
    }

    private void initHeadTail(Node<E> h2, Node<E> t2) {
        if (h2 == t2) {
            if (h2 == null) {
                t2 = new Node();
                h2 = t2;
            } else {
                Node newNode = new Node();
                NEXT.set(t2, newNode);
                PREV.set(newNode, t2);
                t2 = newNode;
            }
        }
        this.head = h2;
        this.tail = t2;
    }

    @Override
    public void addFirst(E e2) {
        this.linkFirst(e2);
    }

    @Override
    public void addLast(E e2) {
        this.linkLast(e2);
    }

    @Override
    public boolean offerFirst(E e2) {
        this.linkFirst(e2);
        return true;
    }

    @Override
    public Object offerFirstAndReturnToken(E e2) {
        return this.linkFirst(e2);
    }

    @Override
    public Object offerLastAndReturnToken(E e2) {
        return this.linkLast(e2);
    }

    @Override
    public void removeToken(Object token) {
        if (!(token instanceof Node)) {
            throw new IllegalArgumentException();
        }
        Node node = (Node)token;
        while (!ITEM.compareAndSet(node, node.item, null)) {
        }
        this.unlink(node);
    }

    @Override
    public boolean offerLast(E e2) {
        this.linkLast(e2);
        return true;
    }

    @Override
    public E peekFirst() {
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                return item;
            }
            p2 = this.succ(p2);
        }
        return null;
    }

    @Override
    public E peekLast() {
        Node<E> p2 = this.last();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                return item;
            }
            p2 = this.pred(p2);
        }
        return null;
    }

    @Override
    public E getFirst() {
        return this.screenNullResult(this.peekFirst());
    }

    @Override
    public E getLast() {
        return this.screenNullResult(this.peekLast());
    }

    @Override
    public E pollFirst() {
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && ITEM.compareAndSet(p2, item, null)) {
                this.unlink(p2);
                return item;
            }
            p2 = this.succ(p2);
        }
        return null;
    }

    @Override
    public E pollLast() {
        Node<E> p2 = this.last();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && ITEM.compareAndSet(p2, item, null)) {
                this.unlink(p2);
                return item;
            }
            p2 = this.pred(p2);
        }
        return null;
    }

    @Override
    public E removeFirst() {
        return this.screenNullResult(this.pollFirst());
    }

    @Override
    public E removeLast() {
        return this.screenNullResult(this.pollLast());
    }

    @Override
    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public boolean add(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public boolean removeFirstOccurrence(Object o2) {
        Objects.requireNonNull(o2);
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && o2.equals(item) && ITEM.compareAndSet(p2, item, null)) {
                this.unlink(p2);
                return true;
            }
            p2 = this.succ(p2);
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o2) {
        Objects.requireNonNull(o2);
        Node<E> p2 = this.last();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && o2.equals(item) && ITEM.compareAndSet(p2, item, null)) {
                this.unlink(p2);
                return true;
            }
            p2 = this.pred(p2);
        }
        return false;
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 != null) {
            Node<E> p2 = this.first();
            while (p2 != null) {
                Object item = p2.item;
                if (item != null && o2.equals(item)) {
                    return true;
                }
                p2 = this.succ(p2);
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.peekFirst() == null;
    }

    @Override
    public int size() {
        int count;
        block0: while (true) {
            count = 0;
            Node<E> p2 = this.first();
            while (p2 != null && (p2.item == null || ++count != Integer.MAX_VALUE)) {
                if (p2 != (p2 = p2.next)) continue;
                continue block0;
            }
            break;
        }
        return count;
    }

    @Override
    public boolean remove(Object o2) {
        return this.removeFirstOccurrence(o2);
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        Node<E> t2;
        if (c2 == this) {
            throw new IllegalArgumentException();
        }
        Node<E> beginningOfTheEnd = null;
        Node<E> last = null;
        for (E e2 : c2) {
            Node<E> newNode = FastConcurrentDirectDeque.newNode(Objects.requireNonNull(e2));
            if (beginningOfTheEnd == null) {
                beginningOfTheEnd = last = newNode;
                continue;
            }
            NEXT.set(last, newNode);
            PREV.set(newNode, last);
            last = newNode;
        }
        if (beginningOfTheEnd == null) {
            return false;
        }
        block1: while (true) {
            Node<E> p2 = t2 = this.tail;
            while (true) {
                Node q2;
                if ((q2 = p2.next) != null) {
                    p2 = q2;
                    q2 = p2.next;
                    if (q2 != null) {
                        p2 = t2 != (t2 = this.tail) ? t2 : q2;
                        continue;
                    }
                }
                if (p2.prev == p2) continue block1;
                PREV.set(beginningOfTheEnd, p2);
                if (NEXT.compareAndSet(p2, null, beginningOfTheEnd)) break block1;
            }
            break;
        }
        if (!TAIL.weakCompareAndSet(this, t2, last)) {
            t2 = this.tail;
            if (last.next == null) {
                TAIL.weakCompareAndSet(this, t2, last);
            }
        }
        return true;
    }

    @Override
    public void clear() {
        while (this.pollFirst() != null) {
        }
    }

    @Override
    public String toString() {
        int size;
        int charLength;
        String[] a2 = null;
        block0: while (true) {
            charLength = 0;
            size = 0;
            Node<E> p2 = this.first();
            while (p2 != null) {
                Object item = p2.item;
                if (item != null) {
                    if (a2 == null) {
                        a2 = new String[4];
                    } else if (size == a2.length) {
                        a2 = Arrays.copyOf(a2, 2 * size);
                    }
                    String s2 = item.toString();
                    a2[size++] = s2;
                    charLength += s2.length();
                }
                if (p2 != (p2 = p2.next)) continue;
                continue block0;
            }
            break;
        }
        if (size == 0) {
            return "[]";
        }
        return this.toString(a2, size, charLength);
    }

    private Object[] toArrayInternal(Object[] a2) {
        int size;
        Object[] x2 = a2;
        block0: while (true) {
            size = 0;
            Node<E> p2 = this.first();
            while (p2 != null) {
                Object item = p2.item;
                if (item != null) {
                    if (x2 == null) {
                        x2 = new Object[4];
                    } else if (size == x2.length) {
                        x2 = Arrays.copyOf(x2, 2 * (size + 4));
                    }
                    x2[size++] = item;
                }
                if (p2 != (p2 = p2.next)) continue;
                continue block0;
            }
            break;
        }
        if (x2 == null) {
            return new Object[0];
        }
        if (a2 != null && size <= a2.length) {
            if (a2 != x2) {
                System.arraycopy(x2, 0, a2, 0, size);
            }
            if (size < a2.length) {
                a2[size] = null;
            }
            return a2;
        }
        return size == x2.length ? x2 : Arrays.copyOf(x2, size);
    }

    @Override
    public Object[] toArray() {
        return this.toArrayInternal(null);
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.toArrayInternal(Assert.checkNotNullParamWithNullPointerException("a", a2));
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    private String toString(Object[] a2, int size, int charLength) {
        char[] chars = new char[charLength + 2 * size];
        chars[0] = 91;
        int j2 = 1;
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 > 0) {
                chars[j2++] = 44;
                chars[j2++] = 32;
            }
            String s2 = (String)a2[i2];
            int len = s2.length();
            s2.getChars(0, len, chars, j2);
            j2 += len;
        }
        chars[j2] = 93;
        return new String(chars);
    }

    @Override
    public Spliterator<E> spliterator() {
        return new CLDSpliterator();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                s2.writeObject(item);
            }
            p2 = this.succ(p2);
        }
        s2.writeObject(null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        Object item;
        s2.defaultReadObject();
        Node<Object> h2 = null;
        Node<Object> t2 = null;
        while ((item = s2.readObject()) != null) {
            Node<Object> newNode = FastConcurrentDirectDeque.newNode(item);
            if (h2 == null) {
                h2 = t2 = newNode;
                continue;
            }
            NEXT.set(t2, newNode);
            PREV.set(newNode, t2);
            t2 = newNode;
        }
        this.initHeadTail(h2, t2);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        return this.bulkRemove(filter);
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        Objects.requireNonNull(c2);
        return this.bulkRemove(e2 -> c2.contains(e2));
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        Objects.requireNonNull(c2);
        return this.bulkRemove(e2 -> !c2.contains(e2));
    }

    private boolean bulkRemove(Predicate<? super E> filter) {
        boolean removed = false;
        Node<E> p2 = this.first();
        while (p2 != null) {
            Node<E> succ = this.succ(p2);
            Object item = p2.item;
            if (item != null && filter.test(item) && ITEM.compareAndSet(p2, item, null)) {
                this.unlink(p2);
                removed = true;
            }
            p2 = succ;
        }
        return removed;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                action.accept(item);
            }
            p2 = this.succ(p2);
        }
    }

    static {
        FastConcurrentDirectDeque.PREV_TERMINATOR.next = PREV_TERMINATOR;
        NEXT_TERMINATOR = new Node();
        FastConcurrentDirectDeque.NEXT_TERMINATOR.prev = NEXT_TERMINATOR;
        try {
            MethodHandles.Lookup l2 = MethodHandles.lookup();
            HEAD = l2.findVarHandle(FastConcurrentDirectDeque.class, "head", Node.class);
            TAIL = l2.findVarHandle(FastConcurrentDirectDeque.class, "tail", Node.class);
            PREV = l2.findVarHandle(Node.class, "prev", Node.class);
            NEXT = l2.findVarHandle(Node.class, "next", Node.class);
            ITEM = l2.findVarHandle(Node.class, "item", Object.class);
        }
        catch (ReflectiveOperationException e2) {
            throw new Error(e2);
        }
    }

    final class CLDSpliterator
    implements Spliterator<E> {
        static final int MAX_BATCH = 0x2000000;
        Node<E> current;
        int batch;
        boolean exhausted;

        CLDSpliterator() {
        }

        @Override
        public Spliterator<E> trySplit() {
            Node q2;
            Node p2 = this.current();
            if (p2 == null || (q2 = p2.next) == null) {
                return null;
            }
            int i2 = 0;
            int n2 = this.batch = Math.min(this.batch + 1, 0x2000000);
            Object[] a2 = null;
            do {
                Object e2;
                if ((e2 = p2.item) != null) {
                    if (a2 == null) {
                        a2 = new Object[n2];
                    }
                    a2[i2++] = e2;
                }
                if (p2 != (p2 = q2)) continue;
                p2 = FastConcurrentDirectDeque.this.first();
            } while (p2 != null && (q2 = p2.next) != null && i2 < n2);
            this.setCurrent(p2);
            return i2 == 0 ? null : Spliterators.spliterator(a2, 0, i2, 4368);
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Node p2 = this.current();
            if (p2 != null) {
                this.current = null;
                this.exhausted = true;
                do {
                    Object e2;
                    if ((e2 = p2.item) != null) {
                        action.accept(e2);
                    }
                    if (p2 != (p2 = p2.next)) continue;
                    p2 = FastConcurrentDirectDeque.this.first();
                } while (p2 != null);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Node p2 = this.current();
            if (p2 != null) {
                Object e2;
                do {
                    e2 = p2.item;
                    if (p2 != (p2 = p2.next)) continue;
                    p2 = FastConcurrentDirectDeque.this.first();
                } while (e2 == null && p2 != null);
                this.setCurrent(p2);
                if (e2 != null) {
                    action.accept(e2);
                    return true;
                }
            }
            return false;
        }

        private void setCurrent(Node<E> p2) {
            this.current = p2;
            if (this.current == null) {
                this.exhausted = true;
            }
        }

        private Node<E> current() {
            Node p2 = this.current;
            if (p2 == null && !this.exhausted) {
                p2 = FastConcurrentDirectDeque.this.first();
                this.setCurrent(p2);
            }
            return p2;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    private class DescendingItr
    extends AbstractItr {
        DescendingItr() {
        }

        @Override
        Node<E> startNode() {
            return FastConcurrentDirectDeque.this.last();
        }

        @Override
        Node<E> nextNode(Node<E> p2) {
            return FastConcurrentDirectDeque.this.pred(p2);
        }
    }

    private class Itr
    extends AbstractItr {
        Itr() {
        }

        @Override
        Node<E> startNode() {
            return FastConcurrentDirectDeque.this.first();
        }

        @Override
        Node<E> nextNode(Node<E> p2) {
            return FastConcurrentDirectDeque.this.succ(p2);
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        abstract Node<E> startNode();

        abstract Node<E> nextNode(Node<E> var1);

        AbstractItr() {
            this.advance();
        }

        private void advance() {
            Node p2;
            this.lastRet = this.nextNode;
            Node node = p2 = this.nextNode == null ? this.startNode() : this.nextNode(this.nextNode);
            while (true) {
                if (p2 == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    break;
                }
                Object item = p2.item;
                if (item != null) {
                    this.nextNode = p2;
                    this.nextItem = item;
                    break;
                }
                p2 = this.nextNode(p2);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public E next() {
            Object item = this.nextItem;
            if (item == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return item;
        }

        @Override
        public void remove() {
            Node l2 = this.lastRet;
            if (l2 == null) {
                throw new IllegalStateException();
            }
            l2.item = null;
            FastConcurrentDirectDeque.this.unlink(l2);
            this.lastRet = null;
        }
    }

    static final class Node<E> {
        volatile Node<E> prev;
        volatile E item;
        volatile Node<E> next;

        Node() {
        }
    }
}

