/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.Headers;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCLogHandler
implements HttpHandler,
Runnable {
    private final HttpHandler next;
    private final String formatString;
    private final ExchangeCompletionListener exchangeCompletionListener = new JDBCLogCompletionListener();
    private final Deque<JDBCLogAttribute> pendingMessages;
    private volatile int state = 0;
    private volatile Executor executor;
    private static final AtomicIntegerFieldUpdater<JDBCLogHandler> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(JDBCLogHandler.class, "state");
    protected boolean useLongContentLength = false;
    private final DataSource dataSource;
    private String tableName;
    private String remoteHostField;
    private String userField;
    private String timestampField;
    private String virtualHostField;
    private String methodField;
    private String queryField;
    private String statusField;
    private String bytesField;
    private String refererField;
    private String userAgentField;

    @Deprecated
    public JDBCLogHandler(HttpHandler next, Executor logWriteExecutor, String formatString, DataSource dataSource) {
        this(next, formatString, dataSource);
    }

    public JDBCLogHandler(HttpHandler next, String formatString, DataSource dataSource) {
        this.next = next;
        this.formatString = formatString;
        this.dataSource = dataSource;
        this.tableName = "access";
        this.remoteHostField = "remoteHost";
        this.userField = "userName";
        this.timestampField = "timestamp";
        this.virtualHostField = "virtualHost";
        this.methodField = "method";
        this.queryField = "query";
        this.statusField = "status";
        this.bytesField = "bytes";
        this.refererField = "referer";
        this.userAgentField = "userAgent";
        this.pendingMessages = new ConcurrentLinkedDeque<JDBCLogAttribute>();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addExchangeCompleteListener(this.exchangeCompletionListener);
        this.next.handleRequest(exchange);
    }

    public void logMessage(String pattern, HttpServerExchange exchange) {
        JDBCLogAttribute jdbcLogAttribute = new JDBCLogAttribute();
        if (pattern.equals("combined")) {
            jdbcLogAttribute.pattern = pattern;
        }
        jdbcLogAttribute.remoteHost = ((InetSocketAddress)exchange.getConnection().getPeerAddress()).getAddress().getHostAddress();
        SecurityContext sc = exchange.getSecurityContext();
        jdbcLogAttribute.user = sc == null || !sc.isAuthenticated() ? null : sc.getAuthenticatedAccount().getPrincipal().getName();
        jdbcLogAttribute.query = exchange.getQueryString();
        jdbcLogAttribute.bytes = exchange.getResponseContentLength();
        if (jdbcLogAttribute.bytes < 0L) {
            jdbcLogAttribute.bytes = 0L;
        }
        jdbcLogAttribute.status = exchange.getStatusCode();
        if (jdbcLogAttribute.pattern.equals("combined")) {
            jdbcLogAttribute.virtualHost = exchange.getRequestHeaders().getFirst(Headers.HOST);
            jdbcLogAttribute.method = exchange.getRequestMethod().toString();
            jdbcLogAttribute.referer = exchange.getRequestHeaders().getFirst(Headers.REFERER);
            jdbcLogAttribute.userAgent = exchange.getRequestHeaders().getFirst(Headers.USER_AGENT);
        }
        this.pendingMessages.add(jdbcLogAttribute);
        int state = stateUpdater.get(this);
        if (state == 0 && stateUpdater.compareAndSet(this, 0, 1)) {
            this.executor = exchange.getConnection().getWorker();
            this.executor.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!stateUpdater.compareAndSet(this, 1, 2)) {
            return;
        }
        ArrayList<JDBCLogAttribute> messages = new ArrayList<JDBCLogAttribute>();
        JDBCLogAttribute msg = null;
        for (int i2 = 0; i2 < 1000 && (msg = this.pendingMessages.poll()) != null; ++i2) {
            messages.add(msg);
        }
        try {
            if (!messages.isEmpty()) {
                this.writeMessage(messages);
            }
        }
        finally {
            Executor executor = this.executor;
            stateUpdater.set(this, 0);
            if (!this.pendingMessages.isEmpty() && stateUpdater.compareAndSet(this, 0, 1)) {
                executor.execute(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessage(List<JDBCLogAttribute> messages) {
        Statement ps = null;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            conn.setAutoCommit(true);
            ps = this.prepareStatement(conn);
            for (JDBCLogAttribute jdbcLogAttribute : messages) {
                for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                    try {
                        ps.clearParameters();
                        ps.setString(1, jdbcLogAttribute.remoteHost);
                        ps.setString(2, jdbcLogAttribute.user);
                        ps.setTimestamp(3, jdbcLogAttribute.timestamp);
                        ps.setString(4, jdbcLogAttribute.query);
                        ps.setInt(5, jdbcLogAttribute.status);
                        if (this.useLongContentLength) {
                            ps.setLong(6, jdbcLogAttribute.bytes);
                        } else {
                            if (jdbcLogAttribute.bytes > Integer.MAX_VALUE) {
                                jdbcLogAttribute.bytes = -1L;
                            }
                            ps.setInt(6, (int)jdbcLogAttribute.bytes);
                        }
                        ps.setString(7, jdbcLogAttribute.virtualHost);
                        ps.setString(8, jdbcLogAttribute.method);
                        ps.setString(9, jdbcLogAttribute.referer);
                        ps.setString(10, jdbcLogAttribute.userAgent);
                        ps.executeUpdate();
                        numberOfTries = 0;
                        continue;
                    }
                    catch (SQLException e2) {
                        UndertowLogger.ROOT_LOGGER.failedToWriteJdbcAccessLog(e2);
                    }
                }
            }
            ps.close();
        }
        catch (SQLException e3) {
            UndertowLogger.ROOT_LOGGER.errorWritingJDBCLog(e3);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e4) {
                    UndertowLogger.ROOT_LOGGER.debug("Exception closing prepared statement", e4);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e5) {
                    UndertowLogger.ROOT_LOGGER.debug("Exception closing connection", e5);
                }
            }
        }
    }

    void awaitWrittenForTest() throws InterruptedException {
        while (!this.pendingMessages.isEmpty()) {
            Thread.sleep(10L);
        }
        while (this.state != 0) {
            Thread.sleep(10L);
        }
    }

    private PreparedStatement prepareStatement(Connection conn) throws SQLException {
        return conn.prepareStatement("INSERT INTO " + this.tableName + " (" + this.remoteHostField + ", " + this.userField + ", " + this.timestampField + ", " + this.queryField + ", " + this.statusField + ", " + this.bytesField + ", " + this.virtualHostField + ", " + this.methodField + ", " + this.refererField + ", " + this.userAgentField + ") VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    }

    public boolean isUseLongContentLength() {
        return this.useLongContentLength;
    }

    public void setUseLongContentLength(boolean useLongContentLength) {
        this.useLongContentLength = useLongContentLength;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getRemoteHostField() {
        return this.remoteHostField;
    }

    public void setRemoteHostField(String remoteHostField) {
        this.remoteHostField = remoteHostField;
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField;
    }

    public String getVirtualHostField() {
        return this.virtualHostField;
    }

    public void setVirtualHostField(String virtualHostField) {
        this.virtualHostField = virtualHostField;
    }

    public String getMethodField() {
        return this.methodField;
    }

    public void setMethodField(String methodField) {
        this.methodField = methodField;
    }

    public String getQueryField() {
        return this.queryField;
    }

    public void setQueryField(String queryField) {
        this.queryField = queryField;
    }

    public String getStatusField() {
        return this.statusField;
    }

    public void setStatusField(String statusField) {
        this.statusField = statusField;
    }

    public String getBytesField() {
        return this.bytesField;
    }

    public void setBytesField(String bytesField) {
        this.bytesField = bytesField;
    }

    public String getRefererField() {
        return this.refererField;
    }

    public void setRefererField(String refererField) {
        this.refererField = refererField;
    }

    public String getUserAgentField() {
        return this.userAgentField;
    }

    public void setUserAgentField(String userAgentField) {
        this.userAgentField = userAgentField;
    }

    public String toString() {
        return "JDBCLogHandler{formatString='" + this.formatString + "'}";
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final DataSource datasource;
        private final String format;
        private final String tableName;
        private final String remoteHostField;
        private final String userField;
        private final String timestampField;
        private final String virtualHostField;
        private final String methodField;
        private final String queryField;
        private final String statusField;
        private final String bytesField;
        private final String refererField;
        private final String userAgentField;

        private Wrapper(String format, DataSource datasource, String tableName, String remoteHostField, String userField, String timestampField, String virtualHostField, String methodField, String queryField, String statusField, String bytesField, String refererField, String userAgentField) {
            this.datasource = datasource;
            this.tableName = tableName;
            this.remoteHostField = remoteHostField;
            this.userField = userField;
            this.timestampField = timestampField;
            this.virtualHostField = virtualHostField;
            this.methodField = methodField;
            this.queryField = queryField;
            this.statusField = statusField;
            this.bytesField = bytesField;
            this.refererField = refererField;
            this.userAgentField = userAgentField;
            this.format = "combined".equals(format) ? "combined" : "common";
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            JDBCLogHandler jdbc = new JDBCLogHandler(handler, this.format, this.datasource);
            if (this.tableName != null) {
                jdbc.setTableName(this.tableName);
            }
            if (this.remoteHostField != null) {
                jdbc.setRemoteHostField(this.remoteHostField);
            }
            if (this.userField != null) {
                jdbc.setUserField(this.userField);
            }
            if (this.timestampField != null) {
                jdbc.setTimestampField(this.timestampField);
            }
            if (this.virtualHostField != null) {
                jdbc.setVirtualHostField(this.virtualHostField);
            }
            if (this.methodField != null) {
                jdbc.setMethodField(this.methodField);
            }
            if (this.queryField != null) {
                jdbc.setQueryField(this.queryField);
            }
            if (this.statusField != null) {
                jdbc.setStatusField(this.statusField);
            }
            if (this.bytesField != null) {
                jdbc.setBytesField(this.bytesField);
            }
            if (this.refererField != null) {
                jdbc.setRefererField(this.refererField);
            }
            if (this.userAgentField != null) {
                jdbc.setUserAgentField(this.userAgentField);
            }
            return jdbc;
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "jdbc-access-log";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("format", String.class);
            params.put("datasource", String.class);
            params.put("tableName", String.class);
            params.put("remoteHostField", String.class);
            params.put("userField", String.class);
            params.put("timestampField", String.class);
            params.put("virtualHostField", String.class);
            params.put("methodField", String.class);
            params.put("queryField", String.class);
            params.put("statusField", String.class);
            params.put("bytesField", String.class);
            params.put("refererField", String.class);
            params.put("userAgentField", String.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("datasource");
        }

        @Override
        public String defaultParameter() {
            return "datasource";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            String datasourceName = (String)config.get("datasource");
            try {
                DataSource ds = (DataSource)new InitialContext().lookup((String)config.get("datasource"));
                String format = (String)config.get("format");
                return new Wrapper(format, ds, (String)config.get("tableName"), (String)config.get("remoteHostField"), (String)config.get("userField"), (String)config.get("timestampField"), (String)config.get("virtualHostField"), (String)config.get("methodField"), (String)config.get("queryField"), (String)config.get("statusField"), (String)config.get("bytesField"), (String)config.get("refererField"), (String)config.get("userAgentField"));
            }
            catch (NamingException ex) {
                throw UndertowMessages.MESSAGES.datasourceNotFound(datasourceName);
            }
        }
    }

    private static class JDBCLogAttribute {
        protected String remoteHost = "";
        protected String user = "";
        protected String query = "";
        protected long bytes = 0L;
        protected int status = 0;
        protected String virtualHost = "";
        protected String method = "";
        protected String referer = "";
        protected String userAgent = "";
        protected String pattern = "common";
        protected Timestamp timestamp = new Timestamp(System.currentTimeMillis());

        private JDBCLogAttribute() {
        }
    }

    private class JDBCLogCompletionListener
    implements ExchangeCompletionListener {
        private JDBCLogCompletionListener() {
        }

        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                JDBCLogHandler.this.logMessage(JDBCLogHandler.this.formatString, exchange);
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

