/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.NetworkUtils;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.xnio.Bits;

public class IPAddressAccessControlHandler
implements HttpHandler {
    private static final Pattern IP4_EXACT = Pattern.compile("(?:\\d{1,3}\\.){3}\\d{1,3}");
    private static final Pattern IP4_WILDCARD = Pattern.compile("(?:(?:\\d{1,3}|\\*)\\.){3}(?:\\d{1,3}|\\*)");
    private static final Pattern IP4_SLASH = Pattern.compile("(?:\\d{1,3}\\.){3}\\d{1,3}\\/\\d\\d?");
    private static final Pattern IP6_EXACT = Pattern.compile("^(?:([0-9a-fA-F]{1,4}:){7,7}(?:[0-9a-fA-F]){1,4}|(?:([0-9a-fA-F]{1,4}:)){1,7}(?:(:))|(?:([0-9a-fA-F]{1,4}:)){1,6}(?:(:[0-9a-fA-F]){1,4})|(?:([0-9a-fA-F]{1,4}:)){1,5}(?:(:[0-9a-fA-F]{1,4})){1,2}|(?:([0-9a-fA-F]{1,4}:)){1,4}(?:(:[0-9a-fA-F]{1,4})){1,3}|(?:([0-9a-fA-F]{1,4}:)){1,3}(?:(:[0-9a-fA-F]{1,4})){1,4}|(?:([0-9a-fA-F]{1,4}:)){1,2}(?:(:[0-9a-fA-F]{1,4})){1,5}|(?:([0-9a-fA-F]{1,4}:))(?:(:[0-9a-fA-F]{1,4})){1,6}|(?:(:))(?:((:[0-9a-fA-F]{1,4}){1,7}|(?:(:)))))$");
    private static final Pattern IP6_WILDCARD = Pattern.compile("(?:(?:[a-zA-Z0-9]{1,4}|\\*):){7}(?:[a-zA-Z0-9]{1,4}|\\*)");
    private static final Pattern IP6_SLASH = Pattern.compile("(?:[a-zA-Z0-9]{1,4}:){7}[a-zA-Z0-9]{1,4}\\/\\d{1,3}");
    private volatile HttpHandler next;
    private volatile boolean defaultAllow = false;
    private final int denyResponseCode;
    private final List<PeerMatch> ipv6acl = new CopyOnWriteArrayList<PeerMatch>();
    private final List<PeerMatch> ipv4acl = new CopyOnWriteArrayList<PeerMatch>();
    private static final boolean traceEnabled = UndertowLogger.PREDICATE_LOGGER.isTraceEnabled();
    private static final boolean debugEnabled = UndertowLogger.PREDICATE_LOGGER.isDebugEnabled();

    public IPAddressAccessControlHandler(HttpHandler next) {
        this(next, 403);
    }

    public IPAddressAccessControlHandler(HttpHandler next, int denyResponseCode) {
        this.next = next;
        this.denyResponseCode = denyResponseCode;
    }

    public IPAddressAccessControlHandler() {
        this.next = ResponseCodeHandler.HANDLE_404;
        this.denyResponseCode = 403;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        InetSocketAddress peer = exchange.getSourceAddress();
        if (this.isAllowed(peer.getAddress())) {
            this.next.handleRequest(exchange);
        } else {
            if (debugEnabled) {
                UndertowLogger.PREDICATE_LOGGER.debugf("Access to [%s] blocked from %s.", (Object)exchange, (Object)peer.getHostString());
            }
            exchange.setStatusCode(this.denyResponseCode);
            exchange.endExchange();
        }
    }

    boolean isAllowed(InetAddress address) {
        block5: {
            block4: {
                if (!(address instanceof Inet4Address)) break block4;
                for (PeerMatch rule : this.ipv4acl) {
                    if (traceEnabled) {
                        UndertowLogger.PREDICATE_LOGGER.tracef("Comparing rule [%s] to IPv4 address %s.", (Object)rule.toPredicateString(), (Object)address.getHostAddress());
                    }
                    if (!rule.matches(address)) continue;
                    return !rule.isDeny();
                }
                break block5;
            }
            if (!(address instanceof Inet6Address)) break block5;
            for (PeerMatch rule : this.ipv6acl) {
                if (traceEnabled) {
                    UndertowLogger.PREDICATE_LOGGER.tracef("Comparing rule [%s] to IPv6 address %s.", (Object)rule.toPredicateString(), (Object)address.getHostAddress());
                }
                if (!rule.matches(address)) continue;
                return !rule.isDeny();
            }
        }
        return this.defaultAllow;
    }

    public int getDenyResponseCode() {
        return this.denyResponseCode;
    }

    public boolean isDefaultAllow() {
        return this.defaultAllow;
    }

    public IPAddressAccessControlHandler setDefaultAllow(boolean defaultAllow) {
        this.defaultAllow = defaultAllow;
        return this;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public IPAddressAccessControlHandler setNext(HttpHandler next) {
        this.next = next;
        return this;
    }

    public IPAddressAccessControlHandler addAllow(String peer) {
        return this.addRule(peer, false);
    }

    public IPAddressAccessControlHandler addDeny(String peer) {
        return this.addRule(peer, true);
    }

    public IPAddressAccessControlHandler clearRules() {
        this.ipv4acl.clear();
        this.ipv6acl.clear();
        return this;
    }

    private IPAddressAccessControlHandler addRule(String peer, boolean deny) {
        if (IP4_EXACT.matcher(peer).matches()) {
            this.addIpV4ExactMatch(peer, deny);
        } else if (IP4_WILDCARD.matcher(peer).matches()) {
            this.addIpV4WildcardMatch(peer, deny);
        } else if (IP4_SLASH.matcher(peer).matches()) {
            this.addIpV4SlashPrefix(peer, deny);
        } else if (IP6_EXACT.matcher(peer).matches()) {
            this.addIpV6ExactMatch(peer, deny);
        } else if (IP6_WILDCARD.matcher(peer).matches()) {
            this.addIpV6WildcardMatch(peer, deny);
        } else if (IP6_SLASH.matcher(peer).matches()) {
            this.addIpV6SlashPrefix(peer, deny);
        } else {
            throw UndertowMessages.MESSAGES.notAValidIpPattern(peer);
        }
        return this;
    }

    private void addIpV6SlashPrefix(String peer, boolean deny) {
        int i2;
        String[] components = peer.split("\\/");
        String[] parts = components[0].split("\\:");
        int maskLen = Integer.parseInt(components[1]);
        assert (parts.length == 8);
        byte[] pattern = new byte[16];
        byte[] mask = new byte[16];
        for (i2 = 0; i2 < 8; ++i2) {
            int val = Integer.parseInt(parts[i2], 16);
            pattern[i2 * 2] = (byte)(val >> 8);
            pattern[i2 * 2 + 1] = (byte)(val & 0xFF);
        }
        for (i2 = 0; i2 < 16; ++i2) {
            if (maskLen > 8) {
                mask[i2] = -1;
                maskLen -= 8;
                continue;
            }
            if (maskLen == 0) break;
            mask[i2] = (byte)(Bits.intBitMask(8 - maskLen, 7) & 0xFF);
            maskLen = 0;
        }
        this.ipv6acl.add(new PrefixIpV6PeerMatch(deny, peer, mask, pattern));
    }

    private void addIpV4SlashPrefix(String peer, boolean deny) {
        String[] components = peer.split("\\/");
        String[] parts = components[0].split("\\.");
        int maskLen = Integer.parseInt(components[1]);
        int mask = Bits.intBitMask(32 - maskLen, 31);
        int prefix = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            prefix <<= 8;
            String part = parts[i2];
            int no = Integer.parseInt(part);
            prefix |= no;
        }
        this.ipv4acl.add(new PrefixIpV4PeerMatch(deny, peer, mask, prefix &= mask));
    }

    private void addIpV6WildcardMatch(String peer, boolean deny) {
        byte[] pattern = new byte[16];
        byte[] mask = new byte[16];
        String[] parts = peer.split("\\:");
        assert (parts.length == 8);
        for (int i2 = 0; i2 < 8; ++i2) {
            if (parts[i2].equals("*")) continue;
            int val = Integer.parseInt(parts[i2], 16);
            pattern[i2 * 2] = (byte)(val >> 8);
            pattern[i2 * 2 + 1] = (byte)(val & 0xFF);
            mask[i2 * 2] = -1;
            mask[i2 * 2 + 1] = -1;
        }
        this.ipv6acl.add(new PrefixIpV6PeerMatch(deny, peer, mask, pattern));
    }

    private void addIpV4WildcardMatch(String peer, boolean deny) {
        String[] parts = peer.split("\\.");
        int mask = 0;
        int prefix = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            mask <<= 8;
            prefix <<= 8;
            String part = parts[i2];
            if (part.equals("*")) continue;
            int no = Integer.parseInt(part);
            mask |= 0xFF;
            prefix |= no;
        }
        this.ipv4acl.add(new PrefixIpV4PeerMatch(deny, peer, mask, prefix));
    }

    private void addIpV6ExactMatch(String peer, boolean deny) {
        try {
            byte[] bytes = NetworkUtils.parseIpv6AddressToBytes(peer);
            this.ipv6acl.add(new ExactIpV6PeerMatch(deny, peer, bytes));
        }
        catch (IOException e2) {
            throw UndertowMessages.MESSAGES.invalidACLAddress(e2);
        }
    }

    private void addIpV4ExactMatch(String peer, boolean deny) {
        String[] parts = peer.split("\\.");
        byte[] bytes = new byte[]{(byte)Integer.parseInt(parts[0]), (byte)Integer.parseInt(parts[1]), (byte)Integer.parseInt(parts[2]), (byte)Integer.parseInt(parts[3])};
        this.ipv4acl.add(new ExactIpV4PeerMatch(deny, peer, bytes));
    }

    public String toString() {
        String predicate = "ip-access-control( default-allow=" + this.defaultAllow + ", acl={ ";
        ArrayList<PeerMatch> acl = new ArrayList<PeerMatch>();
        acl.addAll(this.ipv4acl);
        acl.addAll(this.ipv6acl);
        predicate = predicate + acl.stream().map(s2 -> "'" + s2.toPredicateString() + "'").collect(Collectors.joining(", "));
        predicate = predicate + " }";
        if (this.denyResponseCode != 403) {
            predicate = predicate + ", failure-status=" + this.denyResponseCode;
        }
        predicate = predicate + " )";
        return predicate;
    }

    private static class Holder {
        final String rule;
        final boolean deny;

        private Holder(String rule, boolean deny) {
            this.rule = rule;
            this.deny = deny;
        }
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final List<Holder> peerMatches;
        private final boolean defaultAllow;
        private final int failureStatus;

        private Wrapper(List<Holder> peerMatches, boolean defaultAllow, int failureStatus) {
            this.peerMatches = peerMatches;
            this.defaultAllow = defaultAllow;
            this.failureStatus = failureStatus;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            IPAddressAccessControlHandler res = new IPAddressAccessControlHandler(handler, this.failureStatus);
            for (Holder match : this.peerMatches) {
                if (match.deny) {
                    res.addDeny(match.rule);
                    continue;
                }
                res.addAllow(match.rule);
            }
            res.setDefaultAllow(this.defaultAllow);
            return res;
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "ip-access-control";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("acl", String[].class);
            params.put("failure-status", Integer.TYPE);
            params.put("default-allow", Boolean.TYPE);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("acl");
        }

        @Override
        public String defaultParameter() {
            return "acl";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            String[] acl = (String[])config.get("acl");
            Boolean defaultAllow = (Boolean)config.get("default-allow");
            Integer failureStatus = (Integer)config.get("failure-status");
            ArrayList<Holder> peerMatches = new ArrayList<Holder>();
            for (String rule : acl) {
                String[] parts = rule.split(" ");
                if (parts.length != 2) {
                    throw UndertowMessages.MESSAGES.invalidAclRule(rule);
                }
                if (parts[1].trim().equals("allow")) {
                    peerMatches.add(new Holder(parts[0].trim(), false));
                    continue;
                }
                if (parts[1].trim().equals("deny")) {
                    peerMatches.add(new Holder(parts[0].trim(), true));
                    continue;
                }
                throw UndertowMessages.MESSAGES.invalidAclRule(rule);
            }
            return new Wrapper(peerMatches, defaultAllow == null ? false : defaultAllow, failureStatus == null ? 403 : failureStatus);
        }
    }

    static class PrefixIpV6PeerMatch
    extends PeerMatch {
        private final byte[] mask;
        private final byte[] prefix;

        protected PrefixIpV6PeerMatch(boolean deny, String pattern, byte[] mask, byte[] prefix) {
            super(deny, pattern);
            this.mask = mask;
            this.prefix = prefix;
            assert (mask.length == prefix.length);
        }

        @Override
        boolean matches(InetAddress address) {
            byte[] bytes = address.getAddress();
            if (bytes == null) {
                return false;
            }
            if (bytes.length != this.mask.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.mask.length; ++i2) {
                if ((bytes[i2] & this.mask[i2]) == this.prefix[i2]) continue;
                return false;
            }
            return true;
        }
    }

    private static class PrefixIpV4PeerMatch
    extends PeerMatch {
        private final int mask;
        private final int prefix;

        protected PrefixIpV4PeerMatch(boolean deny, String pattern, int mask, int prefix) {
            super(deny, pattern);
            this.mask = mask;
            this.prefix = prefix;
        }

        @Override
        boolean matches(InetAddress address) {
            byte[] bytes = address.getAddress();
            if (bytes == null) {
                return false;
            }
            int addressInt = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
            return (addressInt & this.mask) == this.prefix;
        }
    }

    static class ExactIpV6PeerMatch
    extends PeerMatch {
        private final byte[] address;

        protected ExactIpV6PeerMatch(boolean deny, String pattern, byte[] address) {
            super(deny, pattern);
            this.address = address;
        }

        @Override
        boolean matches(InetAddress address) {
            return Arrays.equals(address.getAddress(), this.address);
        }
    }

    static class ExactIpV4PeerMatch
    extends PeerMatch {
        private final byte[] address;

        protected ExactIpV4PeerMatch(boolean deny, String pattern, byte[] address) {
            super(deny, pattern);
            this.address = address;
        }

        @Override
        boolean matches(InetAddress address) {
            return Arrays.equals(address.getAddress(), this.address);
        }
    }

    static abstract class PeerMatch {
        private final boolean deny;
        private final String pattern;

        protected PeerMatch(boolean deny, String pattern) {
            this.deny = deny;
            this.pattern = pattern;
        }

        abstract boolean matches(InetAddress var1);

        boolean isDeny() {
            return this.deny;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{deny=" + this.deny + ", pattern='" + this.pattern + "'}";
        }

        public String toPredicateString() {
            return this.pattern + " " + (this.deny ? "deny" : "allow");
        }
    }
}

