/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

public enum CookieSameSiteMode {
    STRICT("Strict"),
    LAX("Lax"),
    NONE("None");

    private static final CookieSameSiteMode[] SAMESITE_MODES;
    private final String label;

    private CookieSameSiteMode(String label) {
        this.label = label;
    }

    public static String lookupModeString(String mode) {
        for (CookieSameSiteMode m2 : SAMESITE_MODES) {
            if (!m2.name().equalsIgnoreCase(mode)) continue;
            return m2.toString();
        }
        return null;
    }

    public String toString() {
        return this.label;
    }

    static {
        SAMESITE_MODES = CookieSameSiteMode.values();
    }
}

