/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.protocol.http.HttpServerConnection;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;
import org.xnio.channels.Channels;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSourceChannel;

public class ConnectionSSLSessionInfo
implements SSLSessionInfo {
    private static final SSLPeerUnverifiedException PEER_UNVERIFIED_EXCEPTION = new SSLPeerUnverifiedException("");
    private static final RenegotiationRequiredException RENEGOTIATION_REQUIRED_EXCEPTION = new RenegotiationRequiredException();
    private static final long MAX_RENEGOTIATION_WAIT = 30000L;
    private final SslChannel channel;
    private final HttpServerConnection serverConnection;
    private SSLPeerUnverifiedException unverified;
    private RenegotiationRequiredException renegotiationRequiredException;

    public ConnectionSSLSessionInfo(SslChannel channel, HttpServerConnection serverConnection) {
        this.channel = channel;
        this.serverConnection = serverConnection;
    }

    @Override
    public byte[] getSessionId() {
        return this.channel.getSslSession().getId();
    }

    @Override
    public String getCipherSuite() {
        return this.channel.getSslSession().getCipherSuite();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        if (this.unverified != null) {
            throw this.unverified;
        }
        if (this.renegotiationRequiredException != null) {
            throw this.renegotiationRequiredException;
        }
        try {
            return this.channel.getSslSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e2) {
            try {
                SslClientAuthMode sslClientAuthMode = this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    this.renegotiationRequiredException = RENEGOTIATION_REQUIRED_EXCEPTION;
                    throw this.renegotiationRequiredException;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.unverified = PEER_UNVERIFIED_EXCEPTION;
            throw this.unverified;
        }
    }

    @Override
    @Deprecated(since="2.2.3", forRemoval=false)
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        if (this.unverified != null) {
            throw this.unverified;
        }
        if (this.renegotiationRequiredException != null) {
            throw this.renegotiationRequiredException;
        }
        try {
            return this.channel.getSslSession().getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e2) {
            try {
                SslClientAuthMode sslClientAuthMode = this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    this.renegotiationRequiredException = RENEGOTIATION_REQUIRED_EXCEPTION;
                    throw this.renegotiationRequiredException;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.unverified = PEER_UNVERIFIED_EXCEPTION;
            throw this.unverified;
        }
    }

    @Override
    public void renegotiate(HttpServerExchange exchange, SslClientAuthMode sslClientAuthMode) throws IOException {
        if ("TLSv1.3".equals(this.channel.getSslSession().getProtocol())) {
            throw UndertowMessages.MESSAGES.renegotiationNotSupported();
        }
        this.unverified = null;
        this.renegotiationRequiredException = null;
        if (exchange.isRequestComplete()) {
            this.renegotiateNoRequest(exchange, sslClientAuthMode);
        } else {
            this.renegotiateBufferRequest(exchange, sslClientAuthMode);
        }
    }

    @Override
    public SSLSession getSSLSession() {
        return this.channel.getSslSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renegotiateBufferRequest(HttpServerExchange exchange, SslClientAuthMode newAuthMode) throws IOException {
        int maxSize = exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, 16384);
        if (maxSize <= 0) {
            throw new SSLPeerUnverifiedException("");
        }
        boolean requestResetRequired = false;
        StreamSourceChannel requestChannel = Connectors.getExistingRequestChannel(exchange);
        if (requestChannel == null) {
            requestChannel = exchange.getRequestChannel();
            requestResetRequired = true;
        }
        PooledByteBuffer pooled = exchange.getConnection().getByteBufferPool().allocate();
        boolean free = true;
        int usedBuffers = 0;
        PooledByteBuffer[] poolArray = null;
        int bufferSize = pooled.getBuffer().remaining();
        int allowedBuffers = (maxSize + bufferSize - 1) / bufferSize;
        poolArray = new PooledByteBuffer[allowedBuffers];
        poolArray[usedBuffers++] = pooled;
        boolean overflow = false;
        try {
            block12: {
                ByteBuffer buf;
                while (true) {
                    buf = pooled.getBuffer();
                    int res = Channels.readBlocking(requestChannel, buf);
                    if (!buf.hasRemaining()) {
                        buf.flip();
                        if (allowedBuffers == usedBuffers) {
                            overflow = true;
                            break block12;
                        }
                        pooled = exchange.getConnection().getByteBufferPool().allocate();
                        poolArray[usedBuffers++] = pooled;
                        continue;
                    }
                    if (res == -1) break;
                }
                buf.flip();
            }
            free = false;
            Connectors.ungetRequestBytes(exchange, poolArray);
            if (overflow) {
                throw new SSLPeerUnverifiedException("Cannot renegotiate");
            }
            this.renegotiateNoRequest(exchange, newAuthMode);
        }
        finally {
            if (free) {
                for (PooledByteBuffer buf : poolArray) {
                    if (buf == null) continue;
                    buf.close();
                }
            }
            if (requestResetRequired) {
                exchange.requestChannel = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renegotiateNoRequest(HttpServerExchange exchange, SslClientAuthMode newAuthMode) throws IOException {
        AbstractServerConnection.ConduitState oldState = this.serverConnection.resetChannel();
        try {
            SslClientAuthMode sslClientAuthMode = this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
            if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                SslHandshakeWaiter waiter = new SslHandshakeWaiter();
                this.channel.getHandshakeSetter().set(waiter);
                this.channel.setOption(Options.SSL_CLIENT_AUTH_MODE, newAuthMode);
                this.channel.getSslSession().invalidate();
                this.channel.startHandshake();
                this.serverConnection.getOriginalSinkConduit().flush();
                ByteBuffer buff = ByteBuffer.wrap(new byte[1]);
                long end = System.currentTimeMillis() + 30000L;
                while (!waiter.isDone() && this.serverConnection.isOpen() && System.currentTimeMillis() < end) {
                    int read = this.serverConnection.getSourceChannel().read(buff);
                    if (read != 0) {
                        throw new SSLPeerUnverifiedException("");
                    }
                    if (waiter.isDone()) continue;
                    this.serverConnection.getSourceChannel().awaitReadable(end - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                }
                if (!waiter.isDone()) {
                    if (this.serverConnection.isOpen()) {
                        IoUtils.safeClose((Closeable)this.serverConnection);
                        throw UndertowMessages.MESSAGES.rengotiationTimedOut();
                    }
                    IoUtils.safeClose((Closeable)this.serverConnection);
                    throw UndertowMessages.MESSAGES.rengotiationFailed();
                }
            }
        }
        finally {
            if (oldState != null) {
                this.serverConnection.restoreChannel(oldState);
            }
        }
    }

    private static class SslHandshakeWaiter
    implements ChannelListener<SslChannel> {
        private volatile boolean done = false;

        private SslHandshakeWaiter() {
        }

        boolean isDone() {
            return this.done;
        }

        @Override
        public void handleEvent(SslChannel channel) {
            this.done = true;
        }
    }
}

