/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.ConnectorStatistics;

public class AggregateConnectorStatistics
implements ConnectorStatistics {
    private final ConnectorStatistics[] connectorStatistics;

    public AggregateConnectorStatistics(ConnectorStatistics[] connectorStatistics) {
        this.connectorStatistics = connectorStatistics;
    }

    @Override
    public long getRequestCount() {
        long count = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            count += c2.getRequestCount();
        }
        return count;
    }

    @Override
    public long getBytesSent() {
        long count = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            count += c2.getBytesSent();
        }
        return count;
    }

    @Override
    public long getBytesReceived() {
        long count = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            count += c2.getBytesReceived();
        }
        return count;
    }

    @Override
    public long getErrorCount() {
        long count = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            count += c2.getErrorCount();
        }
        return count;
    }

    @Override
    public long getProcessingTime() {
        long count = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            count += c2.getProcessingTime();
        }
        return count;
    }

    @Override
    public long getMaxProcessingTime() {
        long max = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            max = Math.max(c2.getMaxProcessingTime(), max);
        }
        return max;
    }

    @Override
    public void reset() {
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            c2.reset();
        }
    }

    @Override
    public long getActiveConnections() {
        long count = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            count += c2.getActiveConnections();
        }
        return count;
    }

    @Override
    public long getMaxActiveConnections() {
        long count = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            count += c2.getMaxActiveConnections();
        }
        return count;
    }

    @Override
    public long getActiveRequests() {
        long count = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            count += c2.getActiveRequests();
        }
        return count;
    }

    @Override
    public long getMaxActiveRequests() {
        long count = 0L;
        for (ConnectorStatistics c2 : this.connectorStatistics) {
            count += c2.getMaxActiveRequests();
        }
        return count;
    }
}

